// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/**
 * The interface for AppPlatformManagementClient class.
 */
public interface AppPlatformManagementClient {
    /**
     * Gets Gets subscription ID which uniquely identify the Microsoft Azure subscription. The subscription ID forms
     * part of the URI for every service call.
     * 
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the ServicesClient object to access its operations.
     * 
     * @return the ServicesClient object.
     */
    ServicesClient getServices();

    /**
     * Gets the ApmsClient object to access its operations.
     * 
     * @return the ApmsClient object.
     */
    ApmsClient getApms();

    /**
     * Gets the ConfigServersClient object to access its operations.
     * 
     * @return the ConfigServersClient object.
     */
    ConfigServersClient getConfigServers();

    /**
     * Gets the ConfigurationServicesClient object to access its operations.
     * 
     * @return the ConfigurationServicesClient object.
     */
    ConfigurationServicesClient getConfigurationServices();

    /**
     * Gets the ServiceRegistriesClient object to access its operations.
     * 
     * @return the ServiceRegistriesClient object.
     */
    ServiceRegistriesClient getServiceRegistries();

    /**
     * Gets the ApplicationLiveViewsClient object to access its operations.
     * 
     * @return the ApplicationLiveViewsClient object.
     */
    ApplicationLiveViewsClient getApplicationLiveViews();

    /**
     * Gets the DevToolPortalsClient object to access its operations.
     * 
     * @return the DevToolPortalsClient object.
     */
    DevToolPortalsClient getDevToolPortals();

    /**
     * Gets the ContainerRegistriesClient object to access its operations.
     * 
     * @return the ContainerRegistriesClient object.
     */
    ContainerRegistriesClient getContainerRegistries();

    /**
     * Gets the BuildServicesClient object to access its operations.
     * 
     * @return the BuildServicesClient object.
     */
    BuildServicesClient getBuildServices();

    /**
     * Gets the BuildpackBindingsClient object to access its operations.
     * 
     * @return the BuildpackBindingsClient object.
     */
    BuildpackBindingsClient getBuildpackBindings();

    /**
     * Gets the BuildServiceBuildersClient object to access its operations.
     * 
     * @return the BuildServiceBuildersClient object.
     */
    BuildServiceBuildersClient getBuildServiceBuilders();

    /**
     * Gets the BuildServiceAgentPoolsClient object to access its operations.
     * 
     * @return the BuildServiceAgentPoolsClient object.
     */
    BuildServiceAgentPoolsClient getBuildServiceAgentPools();

    /**
     * Gets the MonitoringSettingsClient object to access its operations.
     * 
     * @return the MonitoringSettingsClient object.
     */
    MonitoringSettingsClient getMonitoringSettings();

    /**
     * Gets the AppsClient object to access its operations.
     * 
     * @return the AppsClient object.
     */
    AppsClient getApps();

    /**
     * Gets the BindingsClient object to access its operations.
     * 
     * @return the BindingsClient object.
     */
    BindingsClient getBindings();

    /**
     * Gets the StoragesClient object to access its operations.
     * 
     * @return the StoragesClient object.
     */
    StoragesClient getStorages();

    /**
     * Gets the CertificatesClient object to access its operations.
     * 
     * @return the CertificatesClient object.
     */
    CertificatesClient getCertificates();

    /**
     * Gets the CustomDomainsClient object to access its operations.
     * 
     * @return the CustomDomainsClient object.
     */
    CustomDomainsClient getCustomDomains();

    /**
     * Gets the DeploymentsClient object to access its operations.
     * 
     * @return the DeploymentsClient object.
     */
    DeploymentsClient getDeployments();

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the RuntimeVersionsClient object to access its operations.
     * 
     * @return the RuntimeVersionsClient object.
     */
    RuntimeVersionsClient getRuntimeVersions();

    /**
     * Gets the SkusClient object to access its operations.
     * 
     * @return the SkusClient object.
     */
    SkusClient getSkus();

    /**
     * Gets the GatewaysClient object to access its operations.
     * 
     * @return the GatewaysClient object.
     */
    GatewaysClient getGateways();

    /**
     * Gets the GatewayRouteConfigsClient object to access its operations.
     * 
     * @return the GatewayRouteConfigsClient object.
     */
    GatewayRouteConfigsClient getGatewayRouteConfigs();

    /**
     * Gets the GatewayCustomDomainsClient object to access its operations.
     * 
     * @return the GatewayCustomDomainsClient object.
     */
    GatewayCustomDomainsClient getGatewayCustomDomains();

    /**
     * Gets the ApiPortalsClient object to access its operations.
     * 
     * @return the ApiPortalsClient object.
     */
    ApiPortalsClient getApiPortals();

    /**
     * Gets the ApiPortalCustomDomainsClient object to access its operations.
     * 
     * @return the ApiPortalCustomDomainsClient object.
     */
    ApiPortalCustomDomainsClient getApiPortalCustomDomains();

    /**
     * Gets the ApplicationAcceleratorsClient object to access its operations.
     * 
     * @return the ApplicationAcceleratorsClient object.
     */
    ApplicationAcceleratorsClient getApplicationAccelerators();

    /**
     * Gets the CustomizedAcceleratorsClient object to access its operations.
     * 
     * @return the CustomizedAcceleratorsClient object.
     */
    CustomizedAcceleratorsClient getCustomizedAccelerators();

    /**
     * Gets the PredefinedAcceleratorsClient object to access its operations.
     * 
     * @return the PredefinedAcceleratorsClient object.
     */
    PredefinedAcceleratorsClient getPredefinedAccelerators();
}
