// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The basic authentication properties for the container registry resource.
 */
@Fluent
public final class ContainerRegistryBasicCredentials extends ContainerRegistryCredentials {
    /*
     * The credential type of the container registry credentials.
     */
    private String type = "BasicAuth";

    /*
     * The login server of the Container Registry.
     */
    private String server;

    /*
     * The username of the Container Registry.
     */
    private String username;

    /*
     * The password of the Container Registry.
     */
    private String password;

    /**
     * Creates an instance of ContainerRegistryBasicCredentials class.
     */
    public ContainerRegistryBasicCredentials() {
    }

    /**
     * Get the type property: The credential type of the container registry credentials.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the server property: The login server of the Container Registry.
     * 
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: The login server of the Container Registry.
     * 
     * @param server the server value to set.
     * @return the ContainerRegistryBasicCredentials object itself.
     */
    public ContainerRegistryBasicCredentials withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the username property: The username of the Container Registry.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The username of the Container Registry.
     * 
     * @param username the username value to set.
     * @return the ContainerRegistryBasicCredentials object itself.
     */
    public ContainerRegistryBasicCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password of the Container Registry.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password of the Container Registry.
     * 
     * @param password the password value to set.
     * @return the ContainerRegistryBasicCredentials object itself.
     */
    public ContainerRegistryBasicCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (server() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property server in model ContainerRegistryBasicCredentials"));
        }
        if (username() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property username in model ContainerRegistryBasicCredentials"));
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property password in model ContainerRegistryBasicCredentials"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryBasicCredentials.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerRegistryBasicCredentials from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerRegistryBasicCredentials if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerRegistryBasicCredentials.
     */
    public static ContainerRegistryBasicCredentials fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerRegistryBasicCredentials deserializedContainerRegistryBasicCredentials
                = new ContainerRegistryBasicCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("server".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.server = reader.getString();
                } else if ("username".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.username = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.password = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerRegistryBasicCredentials;
        });
    }
}
