// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Build result log resource properties payload.
 */
@Fluent
public final class BuildResultLogInner implements JsonSerializable<BuildResultLogInner> {
    /*
     * The public download URL of this build result log
     */
    private String blobUrl;

    /**
     * Creates an instance of BuildResultLogInner class.
     */
    public BuildResultLogInner() {
    }

    /**
     * Get the blobUrl property: The public download URL of this build result log.
     * 
     * @return the blobUrl value.
     */
    public String blobUrl() {
        return this.blobUrl;
    }

    /**
     * Set the blobUrl property: The public download URL of this build result log.
     * 
     * @param blobUrl the blobUrl value to set.
     * @return the BuildResultLogInner object itself.
     */
    public BuildResultLogInner withBlobUrl(String blobUrl) {
        this.blobUrl = blobUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("blobUrl", this.blobUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildResultLogInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildResultLogInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildResultLogInner.
     */
    public static BuildResultLogInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildResultLogInner deserializedBuildResultLogInner = new BuildResultLogInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("blobUrl".equals(fieldName)) {
                    deserializedBuildResultLogInner.blobUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildResultLogInner;
        });
    }
}
