// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a buildpack binding.
 */
@Fluent
public final class BuildpackBindingProperties implements JsonSerializable<BuildpackBindingProperties> {
    /*
     * Buildpack Binding Type
     */
    private BindingType bindingType;

    /*
     * State of the Buildpack Binding.
     */
    private BuildpackBindingProvisioningState provisioningState;

    /*
     * The object describes the buildpack binding launch properties
     */
    private BuildpackBindingLaunchProperties launchProperties;

    /**
     * Creates an instance of BuildpackBindingProperties class.
     */
    public BuildpackBindingProperties() {
    }

    /**
     * Get the bindingType property: Buildpack Binding Type.
     * 
     * @return the bindingType value.
     */
    public BindingType bindingType() {
        return this.bindingType;
    }

    /**
     * Set the bindingType property: Buildpack Binding Type.
     * 
     * @param bindingType the bindingType value to set.
     * @return the BuildpackBindingProperties object itself.
     */
    public BuildpackBindingProperties withBindingType(BindingType bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    /**
     * Get the provisioningState property: State of the Buildpack Binding.
     * 
     * @return the provisioningState value.
     */
    public BuildpackBindingProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the launchProperties property: The object describes the buildpack binding launch properties.
     * 
     * @return the launchProperties value.
     */
    public BuildpackBindingLaunchProperties launchProperties() {
        return this.launchProperties;
    }

    /**
     * Set the launchProperties property: The object describes the buildpack binding launch properties.
     * 
     * @param launchProperties the launchProperties value to set.
     * @return the BuildpackBindingProperties object itself.
     */
    public BuildpackBindingProperties withLaunchProperties(BuildpackBindingLaunchProperties launchProperties) {
        this.launchProperties = launchProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (launchProperties() != null) {
            launchProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bindingType", this.bindingType == null ? null : this.bindingType.toString());
        jsonWriter.writeJsonField("launchProperties", this.launchProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildpackBindingProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildpackBindingProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildpackBindingProperties.
     */
    public static BuildpackBindingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildpackBindingProperties deserializedBuildpackBindingProperties = new BuildpackBindingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("bindingType".equals(fieldName)) {
                    deserializedBuildpackBindingProperties.bindingType = BindingType.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedBuildpackBindingProperties.provisioningState
                        = BuildpackBindingProvisioningState.fromString(reader.getString());
                } else if ("launchProperties".equals(fieldName)) {
                    deserializedBuildpackBindingProperties.launchProperties
                        = BuildpackBindingLaunchProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildpackBindingProperties;
        });
    }
}
