// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource requests of the API portal.
 */
@Immutable
public final class ApiPortalResourceRequests implements JsonSerializable<ApiPortalResourceRequests> {
    /*
     * Cpu allocated to each API portal instance
     */
    private String cpu;

    /*
     * Memory allocated to each API portal instance
     */
    private String memory;

    /**
     * Creates an instance of ApiPortalResourceRequests class.
     */
    public ApiPortalResourceRequests() {
    }

    /**
     * Get the cpu property: Cpu allocated to each API portal instance.
     * 
     * @return the cpu value.
     */
    public String cpu() {
        return this.cpu;
    }

    /**
     * Get the memory property: Memory allocated to each API portal instance.
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiPortalResourceRequests from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiPortalResourceRequests if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiPortalResourceRequests.
     */
    public static ApiPortalResourceRequests fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiPortalResourceRequests deserializedApiPortalResourceRequests = new ApiPortalResourceRequests();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpu".equals(fieldName)) {
                    deserializedApiPortalResourceRequests.cpu = reader.getString();
                } else if ("memory".equals(fieldName)) {
                    deserializedApiPortalResourceRequests.memory = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiPortalResourceRequests;
        });
    }
}
