// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Customized accelerator properties payload.
 */
@Fluent
public final class CustomizedAcceleratorProperties implements JsonSerializable<CustomizedAcceleratorProperties> {
    /*
     * State of the customized accelerator.
     */
    private CustomizedAcceleratorProvisioningState provisioningState;

    /*
     * Type of the customized accelerator.
     */
    private CustomizedAcceleratorType acceleratorType;

    /*
     * The displayName property.
     */
    private String displayName;

    /*
     * The description property.
     */
    private String description;

    /*
     * The iconUrl property.
     */
    private String iconUrl;

    /*
     * The acceleratorTags property.
     */
    private List<String> acceleratorTags;

    /*
     * Imports references all imports that this accelerator/fragment depends upon.
     */
    private List<String> imports;

    /*
     * The gitRepository property.
     */
    private AcceleratorGitRepository gitRepository;

    /**
     * Creates an instance of CustomizedAcceleratorProperties class.
     */
    public CustomizedAcceleratorProperties() {
    }

    /**
     * Get the provisioningState property: State of the customized accelerator.
     * 
     * @return the provisioningState value.
     */
    public CustomizedAcceleratorProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the acceleratorType property: Type of the customized accelerator.
     * 
     * @return the acceleratorType value.
     */
    public CustomizedAcceleratorType acceleratorType() {
        return this.acceleratorType;
    }

    /**
     * Set the acceleratorType property: Type of the customized accelerator.
     * 
     * @param acceleratorType the acceleratorType value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withAcceleratorType(CustomizedAcceleratorType acceleratorType) {
        this.acceleratorType = acceleratorType;
        return this;
    }

    /**
     * Get the displayName property: The displayName property.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The displayName property.
     * 
     * @param displayName the displayName value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the iconUrl property: The iconUrl property.
     * 
     * @return the iconUrl value.
     */
    public String iconUrl() {
        return this.iconUrl;
    }

    /**
     * Set the iconUrl property: The iconUrl property.
     * 
     * @param iconUrl the iconUrl value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    /**
     * Get the acceleratorTags property: The acceleratorTags property.
     * 
     * @return the acceleratorTags value.
     */
    public List<String> acceleratorTags() {
        return this.acceleratorTags;
    }

    /**
     * Set the acceleratorTags property: The acceleratorTags property.
     * 
     * @param acceleratorTags the acceleratorTags value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withAcceleratorTags(List<String> acceleratorTags) {
        this.acceleratorTags = acceleratorTags;
        return this;
    }

    /**
     * Get the imports property: Imports references all imports that this accelerator/fragment depends upon.
     * 
     * @return the imports value.
     */
    public List<String> imports() {
        return this.imports;
    }

    /**
     * Get the gitRepository property: The gitRepository property.
     * 
     * @return the gitRepository value.
     */
    public AcceleratorGitRepository gitRepository() {
        return this.gitRepository;
    }

    /**
     * Set the gitRepository property: The gitRepository property.
     * 
     * @param gitRepository the gitRepository value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withGitRepository(AcceleratorGitRepository gitRepository) {
        this.gitRepository = gitRepository;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gitRepository() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property gitRepository in model CustomizedAcceleratorProperties"));
        } else {
            gitRepository().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomizedAcceleratorProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("gitRepository", this.gitRepository);
        jsonWriter.writeStringField("acceleratorType",
            this.acceleratorType == null ? null : this.acceleratorType.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("iconUrl", this.iconUrl);
        jsonWriter.writeArrayField("acceleratorTags", this.acceleratorTags,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomizedAcceleratorProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomizedAcceleratorProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomizedAcceleratorProperties.
     */
    public static CustomizedAcceleratorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomizedAcceleratorProperties deserializedCustomizedAcceleratorProperties
                = new CustomizedAcceleratorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("gitRepository".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.gitRepository
                        = AcceleratorGitRepository.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.provisioningState
                        = CustomizedAcceleratorProvisioningState.fromString(reader.getString());
                } else if ("acceleratorType".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.acceleratorType
                        = CustomizedAcceleratorType.fromString(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.description = reader.getString();
                } else if ("iconUrl".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.iconUrl = reader.getString();
                } else if ("acceleratorTags".equals(fieldName)) {
                    List<String> acceleratorTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomizedAcceleratorProperties.acceleratorTags = acceleratorTags;
                } else if ("imports".equals(fieldName)) {
                    List<String> imports = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomizedAcceleratorProperties.imports = imports;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomizedAcceleratorProperties;
        });
    }
}
