// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Diagnostic parameters of diagnostic operations.
 */
@Fluent
public final class DiagnosticParameters implements JsonSerializable<DiagnosticParameters> {
    /*
     * App instance name
     */
    private String appInstance;

    /*
     * Your target file path in your own BYOS
     */
    private String filePath;

    /*
     * Duration of your JFR. 1 min can be represented by 1m or 60s.
     */
    private String duration;

    /**
     * Creates an instance of DiagnosticParameters class.
     */
    public DiagnosticParameters() {
    }

    /**
     * Get the appInstance property: App instance name.
     * 
     * @return the appInstance value.
     */
    public String appInstance() {
        return this.appInstance;
    }

    /**
     * Set the appInstance property: App instance name.
     * 
     * @param appInstance the appInstance value to set.
     * @return the DiagnosticParameters object itself.
     */
    public DiagnosticParameters withAppInstance(String appInstance) {
        this.appInstance = appInstance;
        return this;
    }

    /**
     * Get the filePath property: Your target file path in your own BYOS.
     * 
     * @return the filePath value.
     */
    public String filePath() {
        return this.filePath;
    }

    /**
     * Set the filePath property: Your target file path in your own BYOS.
     * 
     * @param filePath the filePath value to set.
     * @return the DiagnosticParameters object itself.
     */
    public DiagnosticParameters withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    /**
     * Get the duration property: Duration of your JFR. 1 min can be represented by 1m or 60s.
     * 
     * @return the duration value.
     */
    public String duration() {
        return this.duration;
    }

    /**
     * Set the duration property: Duration of your JFR. 1 min can be represented by 1m or 60s.
     * 
     * @param duration the duration value to set.
     * @return the DiagnosticParameters object itself.
     */
    public DiagnosticParameters withDuration(String duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appInstance", this.appInstance);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("duration", this.duration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticParameters.
     */
    public static DiagnosticParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticParameters deserializedDiagnosticParameters = new DiagnosticParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appInstance".equals(fieldName)) {
                    deserializedDiagnosticParameters.appInstance = reader.getString();
                } else if ("filePath".equals(fieldName)) {
                    deserializedDiagnosticParameters.filePath = reader.getString();
                } else if ("duration".equals(fieldName)) {
                    deserializedDiagnosticParameters.duration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticParameters;
        });
    }
}
