// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Details of capabilities available to a SKU in specific zones.
 */
@Fluent
public final class ResourceSkuZoneDetails implements JsonSerializable<ResourceSkuZoneDetails> {
    /*
     * Gets the set of zones that the SKU is available in with the
     * specified capabilities.
     */
    private List<String> name;

    /*
     * Gets a list of capabilities that are available for the SKU in the
     * specified list of zones.
     */
    private List<ResourceSkuCapabilities> capabilities;

    /**
     * Creates an instance of ResourceSkuZoneDetails class.
     */
    public ResourceSkuZoneDetails() {
    }

    /**
     * Get the name property: Gets the set of zones that the SKU is available in with the
     * specified capabilities.
     * 
     * @return the name value.
     */
    public List<String> name() {
        return this.name;
    }

    /**
     * Set the name property: Gets the set of zones that the SKU is available in with the
     * specified capabilities.
     * 
     * @param name the name value to set.
     * @return the ResourceSkuZoneDetails object itself.
     */
    public ResourceSkuZoneDetails withName(List<String> name) {
        this.name = name;
        return this;
    }

    /**
     * Get the capabilities property: Gets a list of capabilities that are available for the SKU in the
     * specified list of zones.
     * 
     * @return the capabilities value.
     */
    public List<ResourceSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: Gets a list of capabilities that are available for the SKU in the
     * specified list of zones.
     * 
     * @param capabilities the capabilities value to set.
     * @return the ResourceSkuZoneDetails object itself.
     */
    public ResourceSkuZoneDetails withCapabilities(List<ResourceSkuCapabilities> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("name", this.name, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuZoneDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuZoneDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSkuZoneDetails.
     */
    public static ResourceSkuZoneDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuZoneDetails deserializedResourceSkuZoneDetails = new ResourceSkuZoneDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    List<String> name = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuZoneDetails.name = name;
                } else if ("capabilities".equals(fieldName)) {
                    List<ResourceSkuCapabilities> capabilities
                        = reader.readArray(reader1 -> ResourceSkuCapabilities.fromJson(reader1));
                    deserializedResourceSkuZoneDetails.capabilities = capabilities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuZoneDetails;
        });
    }
}
