// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Temporary disk payload.
 */
@Fluent
public final class TemporaryDisk implements JsonSerializable<TemporaryDisk> {
    /*
     * Size of the temporary disk in GB
     */
    private Integer sizeInGB;

    /*
     * Mount path of the temporary disk
     */
    private String mountPath;

    /**
     * Creates an instance of TemporaryDisk class.
     */
    public TemporaryDisk() {
    }

    /**
     * Get the sizeInGB property: Size of the temporary disk in GB.
     * 
     * @return the sizeInGB value.
     */
    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    /**
     * Set the sizeInGB property: Size of the temporary disk in GB.
     * 
     * @param sizeInGB the sizeInGB value to set.
     * @return the TemporaryDisk object itself.
     */
    public TemporaryDisk withSizeInGB(Integer sizeInGB) {
        this.sizeInGB = sizeInGB;
        return this;
    }

    /**
     * Get the mountPath property: Mount path of the temporary disk.
     * 
     * @return the mountPath value.
     */
    public String mountPath() {
        return this.mountPath;
    }

    /**
     * Set the mountPath property: Mount path of the temporary disk.
     * 
     * @param mountPath the mountPath value to set.
     * @return the TemporaryDisk object itself.
     */
    public TemporaryDisk withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("sizeInGB", this.sizeInGB);
        jsonWriter.writeStringField("mountPath", this.mountPath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TemporaryDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TemporaryDisk if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TemporaryDisk.
     */
    public static TemporaryDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TemporaryDisk deserializedTemporaryDisk = new TemporaryDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sizeInGB".equals(fieldName)) {
                    deserializedTemporaryDisk.sizeInGB = reader.getNullable(JsonReader::getInt);
                } else if ("mountPath".equals(fieldName)) {
                    deserializedTemporaryDisk.mountPath = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTemporaryDisk;
        });
    }
}
