// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Application Configuration Service properties payload.
 */
@Fluent
public final class ConfigurationServiceProperties implements JsonSerializable<ConfigurationServiceProperties> {
    /*
     * State of the Application Configuration Service.
     */
    private ConfigurationServiceProvisioningState provisioningState;

    /*
     * The generation of the Application Configuration Service.
     */
    private ConfigurationServiceGeneration generation;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    private ConfigurationServiceResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Application Configuration Service.
     */
    private List<ConfigurationServiceInstance> instances;

    /*
     * The settings of Application Configuration Service.
     */
    private ConfigurationServiceSettings settings;

    /**
     * Creates an instance of ConfigurationServiceProperties class.
     */
    public ConfigurationServiceProperties() {
    }

    /**
     * Get the provisioningState property: State of the Application Configuration Service.
     * 
     * @return the provisioningState value.
     */
    public ConfigurationServiceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the generation property: The generation of the Application Configuration Service.
     * 
     * @return the generation value.
     */
    public ConfigurationServiceGeneration generation() {
        return this.generation;
    }

    /**
     * Set the generation property: The generation of the Application Configuration Service.
     * 
     * @param generation the generation value to set.
     * @return the ConfigurationServiceProperties object itself.
     */
    public ConfigurationServiceProperties withGeneration(ConfigurationServiceGeneration generation) {
        this.generation = generation;
        return this;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     * 
     * @return the resourceRequests value.
     */
    public ConfigurationServiceResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to Application Configuration Service.
     * 
     * @return the instances value.
     */
    public List<ConfigurationServiceInstance> instances() {
        return this.instances;
    }

    /**
     * Get the settings property: The settings of Application Configuration Service.
     * 
     * @return the settings value.
     */
    public ConfigurationServiceSettings settings() {
        return this.settings;
    }

    /**
     * Set the settings property: The settings of Application Configuration Service.
     * 
     * @param settings the settings value to set.
     * @return the ConfigurationServiceProperties object itself.
     */
    public ConfigurationServiceProperties withSettings(ConfigurationServiceSettings settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
        if (settings() != null) {
            settings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("generation", this.generation == null ? null : this.generation.toString());
        jsonWriter.writeJsonField("settings", this.settings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationServiceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationServiceProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationServiceProperties.
     */
    public static ConfigurationServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationServiceProperties deserializedConfigurationServiceProperties
                = new ConfigurationServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.provisioningState
                        = ConfigurationServiceProvisioningState.fromString(reader.getString());
                } else if ("generation".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.generation
                        = ConfigurationServiceGeneration.fromString(reader.getString());
                } else if ("resourceRequests".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.resourceRequests
                        = ConfigurationServiceResourceRequests.fromJson(reader);
                } else if ("instances".equals(fieldName)) {
                    List<ConfigurationServiceInstance> instances
                        = reader.readArray(reader1 -> ConfigurationServiceInstance.fromJson(reader1));
                    deserializedConfigurationServiceProperties.instances = instances;
                } else if ("settings".equals(fieldName)) {
                    deserializedConfigurationServiceProperties.settings = ConfigurationServiceSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationServiceProperties;
        });
    }
}
