// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment instance payload.
 */
@Immutable
public final class DeploymentInstance implements JsonSerializable<DeploymentInstance> {
    /*
     * Name of the deployment instance
     */
    private String name;

    /*
     * Status of the deployment instance
     */
    private String status;

    /*
     * Failed reason of the deployment instance
     */
    private String reason;

    /*
     * Discovery status of the deployment instance
     */
    private String discoveryStatus;

    /*
     * Start time of the deployment instance
     */
    private String startTime;

    /*
     * Availability zone information of the deployment instance
     */
    private String zone;

    /**
     * Creates an instance of DeploymentInstance class.
     */
    public DeploymentInstance() {
    }

    /**
     * Get the name property: Name of the deployment instance.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Status of the deployment instance.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Get the reason property: Failed reason of the deployment instance.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Get the discoveryStatus property: Discovery status of the deployment instance.
     * 
     * @return the discoveryStatus value.
     */
    public String discoveryStatus() {
        return this.discoveryStatus;
    }

    /**
     * Get the startTime property: Start time of the deployment instance.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Get the zone property: Availability zone information of the deployment instance.
     * 
     * @return the zone value.
     */
    public String zone() {
        return this.zone;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentInstance if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentInstance.
     */
    public static DeploymentInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentInstance deserializedDeploymentInstance = new DeploymentInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDeploymentInstance.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedDeploymentInstance.status = reader.getString();
                } else if ("reason".equals(fieldName)) {
                    deserializedDeploymentInstance.reason = reader.getString();
                } else if ("discoveryStatus".equals(fieldName)) {
                    deserializedDeploymentInstance.discoveryStatus = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedDeploymentInstance.startTime = reader.getString();
                } else if ("zone".equals(fieldName)) {
                    deserializedDeploymentInstance.zone = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentInstance;
        });
    }
}
