// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The DevToolPortalComponent model.
 */
@Immutable
public final class DevToolPortalComponent implements JsonSerializable<DevToolPortalComponent> {
    /*
     * The name property.
     */
    private String name;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    private DevToolPortalResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Dev Tool Portal.
     */
    private List<DevToolPortalInstance> instances;

    /**
     * Creates an instance of DevToolPortalComponent class.
     */
    public DevToolPortalComponent() {
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     * 
     * @return the resourceRequests value.
     */
    public DevToolPortalResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to Dev Tool Portal.
     * 
     * @return the instances value.
     */
    public List<DevToolPortalInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DevToolPortalComponent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DevToolPortalComponent if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DevToolPortalComponent.
     */
    public static DevToolPortalComponent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DevToolPortalComponent deserializedDevToolPortalComponent = new DevToolPortalComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDevToolPortalComponent.name = reader.getString();
                } else if ("resourceRequests".equals(fieldName)) {
                    deserializedDevToolPortalComponent.resourceRequests
                        = DevToolPortalResourceRequests.fromJson(reader);
                } else if ("instances".equals(fieldName)) {
                    List<DevToolPortalInstance> instances
                        = reader.readArray(reader1 -> DevToolPortalInstance.fromJson(reader1));
                    deserializedDevToolPortalComponent.instances = instances;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDevToolPortalComponent;
        });
    }
}
