// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the Spring Cloud Gateway Operator.
 */
@Immutable
public final class GatewayOperatorProperties implements JsonSerializable<GatewayOperatorProperties> {
    /*
     * The requested resource quantity for required CPU and Memory.
     */
    private GatewayOperatorResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Spring Cloud Gateway operator.
     */
    private List<GatewayInstance> instances;

    /**
     * Creates an instance of GatewayOperatorProperties class.
     */
    public GatewayOperatorProperties() {
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     * 
     * @return the resourceRequests value.
     */
    public GatewayOperatorResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to Spring Cloud Gateway operator.
     * 
     * @return the instances value.
     */
    public List<GatewayInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayOperatorProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayOperatorProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayOperatorProperties.
     */
    public static GatewayOperatorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayOperatorProperties deserializedGatewayOperatorProperties = new GatewayOperatorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceRequests".equals(fieldName)) {
                    deserializedGatewayOperatorProperties.resourceRequests
                        = GatewayOperatorResourceRequests.fromJson(reader);
                } else if ("instances".equals(fieldName)) {
                    List<GatewayInstance> instances = reader.readArray(reader1 -> GatewayInstance.fromJson(reader1));
                    deserializedGatewayOperatorProperties.instances = instances;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayOperatorProperties;
        });
    }
}
