// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Client-Certification Authentication.
 */
@Fluent
public final class GatewayPropertiesClientAuth implements JsonSerializable<GatewayPropertiesClientAuth> {
    /*
     * Collection of certificate resource Ids in Azure Spring Apps.
     */
    private List<String> certificates;

    /*
     * Whether to enable certificate verification or not
     */
    private GatewayCertificateVerification certificateVerification;

    /**
     * Creates an instance of GatewayPropertiesClientAuth class.
     */
    public GatewayPropertiesClientAuth() {
    }

    /**
     * Get the certificates property: Collection of certificate resource Ids in Azure Spring Apps.
     * 
     * @return the certificates value.
     */
    public List<String> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: Collection of certificate resource Ids in Azure Spring Apps.
     * 
     * @param certificates the certificates value to set.
     * @return the GatewayPropertiesClientAuth object itself.
     */
    public GatewayPropertiesClientAuth withCertificates(List<String> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the certificateVerification property: Whether to enable certificate verification or not.
     * 
     * @return the certificateVerification value.
     */
    public GatewayCertificateVerification certificateVerification() {
        return this.certificateVerification;
    }

    /**
     * Set the certificateVerification property: Whether to enable certificate verification or not.
     * 
     * @param certificateVerification the certificateVerification value to set.
     * @return the GatewayPropertiesClientAuth object itself.
     */
    public GatewayPropertiesClientAuth
        withCertificateVerification(GatewayCertificateVerification certificateVerification) {
        this.certificateVerification = certificateVerification;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("certificateVerification",
            this.certificateVerification == null ? null : this.certificateVerification.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayPropertiesClientAuth from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayPropertiesClientAuth if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayPropertiesClientAuth.
     */
    public static GatewayPropertiesClientAuth fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayPropertiesClientAuth deserializedGatewayPropertiesClientAuth = new GatewayPropertiesClientAuth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("certificates".equals(fieldName)) {
                    List<String> certificates = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayPropertiesClientAuth.certificates = certificates;
                } else if ("certificateVerification".equals(fieldName)) {
                    deserializedGatewayPropertiesClientAuth.certificateVerification
                        = GatewayCertificateVerification.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayPropertiesClientAuth;
        });
    }
}
