// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.fluent.models.SupportedServerVersionInner;
import java.io.IOException;
import java.util.List;

/**
 * Supported server versions.
 */
@Fluent
public final class SupportedServerVersions implements JsonSerializable<SupportedServerVersions> {
    /*
     * Collection of the supported server versions.
     */
    private List<SupportedServerVersionInner> value;

    /*
     * URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     */
    private String nextLink;

    /**
     * Creates an instance of SupportedServerVersions class.
     */
    public SupportedServerVersions() {
    }

    /**
     * Get the value property: Collection of the supported server versions.
     * 
     * @return the value value.
     */
    public List<SupportedServerVersionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of the supported server versions.
     * 
     * @param value the value value to set.
     * @return the SupportedServerVersions object itself.
     */
    public SupportedServerVersions withValue(List<SupportedServerVersionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SupportedServerVersions object itself.
     */
    public SupportedServerVersions withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SupportedServerVersions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SupportedServerVersions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SupportedServerVersions.
     */
    public static SupportedServerVersions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SupportedServerVersions deserializedSupportedServerVersions = new SupportedServerVersions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SupportedServerVersionInner> value
                        = reader.readArray(reader1 -> SupportedServerVersionInner.fromJson(reader1));
                    deserializedSupportedServerVersions.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSupportedServerVersions.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSupportedServerVersions;
        });
    }
}
