// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Validation result for container registry properties.
 */
@Fluent
public final class ContainerRegistryValidateResultInner
    implements JsonSerializable<ContainerRegistryValidateResultInner> {
    /*
     * Indicate if the container registry properties are valid
     */
    private Boolean isValid;

    /*
     * Detailed validation messages.
     */
    private String message;

    /**
     * Creates an instance of ContainerRegistryValidateResultInner class.
     */
    public ContainerRegistryValidateResultInner() {
    }

    /**
     * Get the isValid property: Indicate if the container registry properties are valid.
     * 
     * @return the isValid value.
     */
    public Boolean isValid() {
        return this.isValid;
    }

    /**
     * Set the isValid property: Indicate if the container registry properties are valid.
     * 
     * @param isValid the isValid value to set.
     * @return the ContainerRegistryValidateResultInner object itself.
     */
    public ContainerRegistryValidateResultInner withIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    /**
     * Get the message property: Detailed validation messages.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Detailed validation messages.
     * 
     * @param message the message value to set.
     * @return the ContainerRegistryValidateResultInner object itself.
     */
    public ContainerRegistryValidateResultInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isValid", this.isValid);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerRegistryValidateResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerRegistryValidateResultInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerRegistryValidateResultInner.
     */
    public static ContainerRegistryValidateResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerRegistryValidateResultInner deserializedContainerRegistryValidateResultInner
                = new ContainerRegistryValidateResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isValid".equals(fieldName)) {
                    deserializedContainerRegistryValidateResultInner.isValid
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("message".equals(fieldName)) {
                    deserializedContainerRegistryValidateResultInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerRegistryValidateResultInner;
        });
    }
}
