// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appplatform.fluent.CustomizedAcceleratorsClient;
import com.azure.resourcemanager.appplatform.fluent.models.CustomizedAcceleratorResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.CustomizedAcceleratorValidateResultInner;
import com.azure.resourcemanager.appplatform.models.CustomizedAcceleratorProperties;
import com.azure.resourcemanager.appplatform.models.CustomizedAcceleratorResourceCollection;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CustomizedAcceleratorsClient.
 */
public final class CustomizedAcceleratorsClientImpl implements CustomizedAcceleratorsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CustomizedAcceleratorsService service;

    /**
     * The service client containing this operation class.
     */
    private final AppPlatformManagementClientImpl client;

    /**
     * Initializes an instance of CustomizedAcceleratorsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    CustomizedAcceleratorsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(CustomizedAcceleratorsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AppPlatformManagementClientCustomizedAccelerators to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AppPlatformManagemen")
    public interface CustomizedAcceleratorsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/customizedAccelerators")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CustomizedAcceleratorResourceCollection>> list(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("applicationAcceleratorName") String applicationAcceleratorName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/customizedAccelerators/{customizedAcceleratorName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CustomizedAcceleratorResourceInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("applicationAcceleratorName") String applicationAcceleratorName,
            @PathParam("customizedAcceleratorName") String customizedAcceleratorName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/customizedAccelerators/{customizedAcceleratorName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("applicationAcceleratorName") String applicationAcceleratorName,
            @PathParam("customizedAcceleratorName") String customizedAcceleratorName,
            @BodyParam("application/json") CustomizedAcceleratorResourceInner customizedAcceleratorResource,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/customizedAccelerators/{customizedAcceleratorName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("applicationAcceleratorName") String applicationAcceleratorName,
            @PathParam("customizedAcceleratorName") String customizedAcceleratorName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/customizedAccelerators/{customizedAcceleratorName}/validate")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("applicationAcceleratorName") String applicationAcceleratorName,
            @PathParam("customizedAcceleratorName") String customizedAcceleratorName,
            @BodyParam("application/json") CustomizedAcceleratorProperties properties,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CustomizedAcceleratorResourceCollection>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomizedAcceleratorResourceInner>> listSinglePageAsync(String resourceGroupName,
        String serviceName, String applicationAcceleratorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, accept,
                context))
            .<PagedResponse<CustomizedAcceleratorResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomizedAcceleratorResourceInner>> listSinglePageAsync(String resourceGroupName,
        String serviceName, String applicationAcceleratorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
                resourceGroupName, serviceName, applicationAcceleratorName, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CustomizedAcceleratorResourceInner> listAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, serviceName, applicationAcceleratorName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CustomizedAcceleratorResourceInner> listAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, serviceName, applicationAcceleratorName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CustomizedAcceleratorResourceInner> list(String resourceGroupName, String serviceName,
        String applicationAcceleratorName) {
        return new PagedIterable<>(listAsync(resourceGroupName, serviceName, applicationAcceleratorName));
    }

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CustomizedAcceleratorResourceInner> list(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, serviceName, applicationAcceleratorName, context));
    }

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CustomizedAcceleratorResourceInner>> getWithResponseAsync(String resourceGroupName,
        String serviceName, String applicationAcceleratorName, String customizedAcceleratorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName,
                customizedAcceleratorName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CustomizedAcceleratorResourceInner>> getWithResponseAsync(String resourceGroupName,
        String serviceName, String applicationAcceleratorName, String customizedAcceleratorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
            resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName, accept, context);
    }

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomizedAcceleratorResourceInner> getAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName) {
        return getWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName,
            customizedAcceleratorName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CustomizedAcceleratorResourceInner> getWithResponse(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, Context context) {
        return getWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName,
            customizedAcceleratorName, context).block();
    }

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomizedAcceleratorResourceInner get(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName) {
        return getWithResponse(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
            Context.NONE).getValue();
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String serviceName, String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorResource == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter customizedAcceleratorResource is required and cannot be null."));
        } else {
            customizedAcceleratorResource.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName,
                customizedAcceleratorName, customizedAcceleratorResource, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String serviceName, String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorResource == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter customizedAcceleratorResource is required and cannot be null."));
        } else {
            customizedAcceleratorResource.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(),
            this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName,
            customizedAcceleratorName, customizedAcceleratorResource, accept, context);
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomizedAcceleratorResourceInner>, CustomizedAcceleratorResourceInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorResourceInner customizedAcceleratorResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, serviceName,
            applicationAcceleratorName, customizedAcceleratorName, customizedAcceleratorResource);
        return this.client.<CustomizedAcceleratorResourceInner, CustomizedAcceleratorResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), CustomizedAcceleratorResourceInner.class,
            CustomizedAcceleratorResourceInner.class, this.client.getContext());
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomizedAcceleratorResourceInner>, CustomizedAcceleratorResourceInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorResourceInner customizedAcceleratorResource,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, serviceName,
            applicationAcceleratorName, customizedAcceleratorName, customizedAcceleratorResource, context);
        return this.client.<CustomizedAcceleratorResourceInner, CustomizedAcceleratorResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), CustomizedAcceleratorResourceInner.class,
            CustomizedAcceleratorResourceInner.class, context);
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomizedAcceleratorResourceInner>, CustomizedAcceleratorResourceInner>
        beginCreateOrUpdate(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorResourceInner customizedAcceleratorResource) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationAcceleratorName,
                customizedAcceleratorName, customizedAcceleratorResource)
            .getSyncPoller();
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomizedAcceleratorResourceInner>, CustomizedAcceleratorResourceInner>
        beginCreateOrUpdate(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorResourceInner customizedAcceleratorResource,
            Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationAcceleratorName,
                customizedAcceleratorName, customizedAcceleratorResource, context)
            .getSyncPoller();
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomizedAcceleratorResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource) {
        return beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationAcceleratorName,
            customizedAcceleratorName, customizedAcceleratorResource).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CustomizedAcceleratorResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationAcceleratorName,
            customizedAcceleratorName, customizedAcceleratorResource, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomizedAcceleratorResourceInner createOrUpdate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource) {
        return createOrUpdateAsync(resourceGroupName, serviceName, applicationAcceleratorName,
            customizedAcceleratorName, customizedAcceleratorResource).block();
    }

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomizedAcceleratorResourceInner createOrUpdate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource, Context context) {
        return createOrUpdateAsync(resourceGroupName, serviceName, applicationAcceleratorName,
            customizedAcceleratorName, customizedAcceleratorResource, context).block();
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName,
                customizedAcceleratorName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
            resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName, accept, context);
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, serviceName,
            applicationAcceleratorName, customizedAcceleratorName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, serviceName,
            applicationAcceleratorName, customizedAcceleratorName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName) {
        return this
            .beginDeleteAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName)
            .getSyncPoller();
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, Context context) {
        return this
            .beginDeleteAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
                context)
            .getSyncPoller();
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName) {
        return beginDeleteAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName, Context context) {
        return beginDeleteAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName) {
        deleteAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName).block();
    }

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName, Context context) {
        deleteAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName, context)
            .block();
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error(new IllegalArgumentException("Parameter properties is required and cannot be null."));
        } else {
            properties.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validate(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName,
                customizedAcceleratorName, properties, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, CustomizedAcceleratorProperties properties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (customizedAcceleratorName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter customizedAcceleratorName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error(new IllegalArgumentException("Parameter properties is required and cannot be null."));
        } else {
            properties.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
            resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName, properties, accept,
            context);
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomizedAcceleratorValidateResultInner>, CustomizedAcceleratorValidateResultInner>
        beginValidateAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = validateWithResponseAsync(resourceGroupName, serviceName,
            applicationAcceleratorName, customizedAcceleratorName, properties);
        return this.client
            .<CustomizedAcceleratorValidateResultInner, CustomizedAcceleratorValidateResultInner>getLroResult(mono,
                this.client.getHttpPipeline(), CustomizedAcceleratorValidateResultInner.class,
                CustomizedAcceleratorValidateResultInner.class, this.client.getContext());
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomizedAcceleratorValidateResultInner>, CustomizedAcceleratorValidateResultInner>
        beginValidateAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = validateWithResponseAsync(resourceGroupName, serviceName,
            applicationAcceleratorName, customizedAcceleratorName, properties, context);
        return this.client
            .<CustomizedAcceleratorValidateResultInner, CustomizedAcceleratorValidateResultInner>getLroResult(mono,
                this.client.getHttpPipeline(), CustomizedAcceleratorValidateResultInner.class,
                CustomizedAcceleratorValidateResultInner.class, context);
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomizedAcceleratorValidateResultInner>, CustomizedAcceleratorValidateResultInner>
        beginValidate(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorProperties properties) {
        return this
            .beginValidateAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
                properties)
            .getSyncPoller();
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomizedAcceleratorValidateResultInner>, CustomizedAcceleratorValidateResultInner>
        beginValidate(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorProperties properties, Context context) {
        return this
            .beginValidateAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
                properties, context)
            .getSyncPoller();
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomizedAcceleratorValidateResultInner> validateAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorProperties properties) {
        return beginValidateAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
            properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CustomizedAcceleratorValidateResultInner> validateAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, CustomizedAcceleratorProperties properties,
        Context context) {
        return beginValidateAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
            properties, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomizedAcceleratorValidateResultInner validate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorProperties properties) {
        return validateAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
            properties).block();
    }

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomizedAcceleratorValidateResultInner validate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, CustomizedAcceleratorProperties properties,
        Context context) {
        return validateAsync(resourceGroupName, serviceName, applicationAcceleratorName, customizedAcceleratorName,
            properties, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomizedAcceleratorResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<CustomizedAcceleratorResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomizedAcceleratorResourceInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
