// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Auth setting for basic auth.
 */
@Fluent
public final class AcceleratorBasicAuthSetting extends AcceleratorAuthSetting {
    /*
     * The type of the auth setting.
     */
    private String authType = "BasicAuth";

    /*
     * Resource Id of CA certificate for https URL of Git repository.
     */
    private String caCertResourceId;

    /*
     * Username of git repository basic auth.
     */
    private String username;

    /*
     * Password of git repository basic auth.
     */
    private String password;

    /**
     * Creates an instance of AcceleratorBasicAuthSetting class.
     */
    public AcceleratorBasicAuthSetting() {
    }

    /**
     * Get the authType property: The type of the auth setting.
     * 
     * @return the authType value.
     */
    @Override
    public String authType() {
        return this.authType;
    }

    /**
     * Get the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @return the caCertResourceId value.
     */
    public String caCertResourceId() {
        return this.caCertResourceId;
    }

    /**
     * Set the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @param caCertResourceId the caCertResourceId value to set.
     * @return the AcceleratorBasicAuthSetting object itself.
     */
    public AcceleratorBasicAuthSetting withCaCertResourceId(String caCertResourceId) {
        this.caCertResourceId = caCertResourceId;
        return this;
    }

    /**
     * Get the username property: Username of git repository basic auth.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: Username of git repository basic auth.
     * 
     * @param username the username value to set.
     * @return the AcceleratorBasicAuthSetting object itself.
     */
    public AcceleratorBasicAuthSetting withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password of git repository basic auth.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: Password of git repository basic auth.
     * 
     * @param password the password value to set.
     * @return the AcceleratorBasicAuthSetting object itself.
     */
    public AcceleratorBasicAuthSetting withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (username() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property username in model AcceleratorBasicAuthSetting"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AcceleratorBasicAuthSetting.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("authType", this.authType);
        jsonWriter.writeStringField("caCertResourceId", this.caCertResourceId);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcceleratorBasicAuthSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcceleratorBasicAuthSetting if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcceleratorBasicAuthSetting.
     */
    public static AcceleratorBasicAuthSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcceleratorBasicAuthSetting deserializedAcceleratorBasicAuthSetting = new AcceleratorBasicAuthSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("username".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.username = reader.getString();
                } else if ("authType".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.authType = reader.getString();
                } else if ("caCertResourceId".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.caCertResourceId = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.password = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcceleratorBasicAuthSetting;
        });
    }
}
