// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Properties of an APM.
 */
@Fluent
public final class ApmProperties implements JsonSerializable<ApmProperties> {
    /*
     * APM Type
     */
    private String type;

    /*
     * State of the APM.
     */
    private ApmProvisioningState provisioningState;

    /*
     * Non-sensitive properties for the APM
     */
    private Map<String, String> properties;

    /*
     * Sensitive properties for the APM
     */
    private Map<String, String> secrets;

    /**
     * Creates an instance of ApmProperties class.
     */
    public ApmProperties() {
    }

    /**
     * Get the type property: APM Type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: APM Type.
     * 
     * @param type the type value to set.
     * @return the ApmProperties object itself.
     */
    public ApmProperties withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the provisioningState property: State of the APM.
     * 
     * @return the provisioningState value.
     */
    public ApmProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the properties property: Non-sensitive properties for the APM.
     * 
     * @return the properties value.
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Non-sensitive properties for the APM.
     * 
     * @param properties the properties value to set.
     * @return the ApmProperties object itself.
     */
    public ApmProperties withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the secrets property: Sensitive properties for the APM.
     * 
     * @return the secrets value.
     */
    public Map<String, String> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Sensitive properties for the APM.
     * 
     * @param secrets the secrets value to set.
     * @return the ApmProperties object itself.
     */
    public ApmProperties withSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model ApmProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApmProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("secrets", this.secrets, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApmProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApmProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApmProperties.
     */
    public static ApmProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApmProperties deserializedApmProperties = new ApmProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedApmProperties.type = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApmProperties.provisioningState = ApmProvisioningState.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    Map<String, String> properties = reader.readMap(reader1 -> reader1.getString());
                    deserializedApmProperties.properties = properties;
                } else if ("secrets".equals(fieldName)) {
                    Map<String, String> secrets = reader.readMap(reader1 -> reader1.getString());
                    deserializedApmProperties.secrets = secrets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApmProperties;
        });
    }
}
