// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Detail settings for Dev Tool Portal feature.
 */
@Fluent
public final class DevToolPortalFeatureDetail implements JsonSerializable<DevToolPortalFeatureDetail> {
    /*
     * State of the plugin
     */
    private DevToolPortalFeatureState state;

    /*
     * Route path to visit the plugin
     */
    private String route;

    /**
     * Creates an instance of DevToolPortalFeatureDetail class.
     */
    public DevToolPortalFeatureDetail() {
    }

    /**
     * Get the state property: State of the plugin.
     * 
     * @return the state value.
     */
    public DevToolPortalFeatureState state() {
        return this.state;
    }

    /**
     * Set the state property: State of the plugin.
     * 
     * @param state the state value to set.
     * @return the DevToolPortalFeatureDetail object itself.
     */
    public DevToolPortalFeatureDetail withState(DevToolPortalFeatureState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the route property: Route path to visit the plugin.
     * 
     * @return the route value.
     */
    public String route() {
        return this.route;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DevToolPortalFeatureDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DevToolPortalFeatureDetail if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DevToolPortalFeatureDetail.
     */
    public static DevToolPortalFeatureDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DevToolPortalFeatureDetail deserializedDevToolPortalFeatureDetail = new DevToolPortalFeatureDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedDevToolPortalFeatureDetail.state
                        = DevToolPortalFeatureState.fromString(reader.getString());
                } else if ("route".equals(fieldName)) {
                    deserializedDevToolPortalFeatureDetail.route = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDevToolPortalFeatureDetail;
        });
    }
}
