// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Dev Tool Portal properties payload.
 */
@Fluent
public final class DevToolPortalProperties implements JsonSerializable<DevToolPortalProperties> {
    /*
     * State of the Dev Tool Portal.
     */
    private DevToolPortalProvisioningState provisioningState;

    /*
     * Collection of components belong to Dev Tool Portal.
     */
    private List<DevToolPortalComponent> components;

    /*
     * Indicates whether the resource exposes public endpoint
     */
    private Boolean publicProperty;

    /*
     * URL of the resource, exposed when 'public' is true.
     */
    private String url;

    /*
     * Single sign-on related configuration
     */
    private DevToolPortalSsoProperties ssoProperties;

    /*
     * Settings for Dev Tool Portal
     */
    private DevToolPortalFeatureSettings features;

    /**
     * Creates an instance of DevToolPortalProperties class.
     */
    public DevToolPortalProperties() {
    }

    /**
     * Get the provisioningState property: State of the Dev Tool Portal.
     * 
     * @return the provisioningState value.
     */
    public DevToolPortalProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the components property: Collection of components belong to Dev Tool Portal.
     * 
     * @return the components value.
     */
    public List<DevToolPortalComponent> components() {
        return this.components;
    }

    /**
     * Get the publicProperty property: Indicates whether the resource exposes public endpoint.
     * 
     * @return the publicProperty value.
     */
    public Boolean publicProperty() {
        return this.publicProperty;
    }

    /**
     * Set the publicProperty property: Indicates whether the resource exposes public endpoint.
     * 
     * @param publicProperty the publicProperty value to set.
     * @return the DevToolPortalProperties object itself.
     */
    public DevToolPortalProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    /**
     * Get the url property: URL of the resource, exposed when 'public' is true.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Get the ssoProperties property: Single sign-on related configuration.
     * 
     * @return the ssoProperties value.
     */
    public DevToolPortalSsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    /**
     * Set the ssoProperties property: Single sign-on related configuration.
     * 
     * @param ssoProperties the ssoProperties value to set.
     * @return the DevToolPortalProperties object itself.
     */
    public DevToolPortalProperties withSsoProperties(DevToolPortalSsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    /**
     * Get the features property: Settings for Dev Tool Portal.
     * 
     * @return the features value.
     */
    public DevToolPortalFeatureSettings features() {
        return this.features;
    }

    /**
     * Set the features property: Settings for Dev Tool Portal.
     * 
     * @param features the features value to set.
     * @return the DevToolPortalProperties object itself.
     */
    public DevToolPortalProperties withFeatures(DevToolPortalFeatureSettings features) {
        this.features = features;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().forEach(e -> e.validate());
        }
        if (ssoProperties() != null) {
            ssoProperties().validate();
        }
        if (features() != null) {
            features().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("public", this.publicProperty);
        jsonWriter.writeJsonField("ssoProperties", this.ssoProperties);
        jsonWriter.writeJsonField("features", this.features);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DevToolPortalProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DevToolPortalProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DevToolPortalProperties.
     */
    public static DevToolPortalProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DevToolPortalProperties deserializedDevToolPortalProperties = new DevToolPortalProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedDevToolPortalProperties.provisioningState
                        = DevToolPortalProvisioningState.fromString(reader.getString());
                } else if ("components".equals(fieldName)) {
                    List<DevToolPortalComponent> components
                        = reader.readArray(reader1 -> DevToolPortalComponent.fromJson(reader1));
                    deserializedDevToolPortalProperties.components = components;
                } else if ("public".equals(fieldName)) {
                    deserializedDevToolPortalProperties.publicProperty = reader.getNullable(JsonReader::getBoolean);
                } else if ("url".equals(fieldName)) {
                    deserializedDevToolPortalProperties.url = reader.getString();
                } else if ("ssoProperties".equals(fieldName)) {
                    deserializedDevToolPortalProperties.ssoProperties = DevToolPortalSsoProperties.fromJson(reader);
                } else if ("features".equals(fieldName)) {
                    deserializedDevToolPortalProperties.features = DevToolPortalFeatureSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDevToolPortalProperties;
        });
    }
}
