// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Supported deployment runtime version descriptor.
 */
@Fluent
public final class SupportedRuntimeVersion implements JsonSerializable<SupportedRuntimeVersion> {
    /*
     * The raw value which could be passed to deployment CRUD operations.
     */
    private SupportedRuntimeValue value;

    /*
     * The platform of this runtime version (possible values: "Java" or ".NET").
     */
    private SupportedRuntimePlatform platform;

    /*
     * The detailed version (major.minor) of the platform.
     */
    private String version;

    /**
     * Creates an instance of SupportedRuntimeVersion class.
     */
    public SupportedRuntimeVersion() {
    }

    /**
     * Get the value property: The raw value which could be passed to deployment CRUD operations.
     * 
     * @return the value value.
     */
    public SupportedRuntimeValue value() {
        return this.value;
    }

    /**
     * Set the value property: The raw value which could be passed to deployment CRUD operations.
     * 
     * @param value the value value to set.
     * @return the SupportedRuntimeVersion object itself.
     */
    public SupportedRuntimeVersion withValue(SupportedRuntimeValue value) {
        this.value = value;
        return this;
    }

    /**
     * Get the platform property: The platform of this runtime version (possible values: "Java" or ".NET").
     * 
     * @return the platform value.
     */
    public SupportedRuntimePlatform platform() {
        return this.platform;
    }

    /**
     * Set the platform property: The platform of this runtime version (possible values: "Java" or ".NET").
     * 
     * @param platform the platform value to set.
     * @return the SupportedRuntimeVersion object itself.
     */
    public SupportedRuntimeVersion withPlatform(SupportedRuntimePlatform platform) {
        this.platform = platform;
        return this;
    }

    /**
     * Get the version property: The detailed version (major.minor) of the platform.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The detailed version (major.minor) of the platform.
     * 
     * @param version the version value to set.
     * @return the SupportedRuntimeVersion object itself.
     */
    public SupportedRuntimeVersion withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value == null ? null : this.value.toString());
        jsonWriter.writeStringField("platform", this.platform == null ? null : this.platform.toString());
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SupportedRuntimeVersion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SupportedRuntimeVersion if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SupportedRuntimeVersion.
     */
    public static SupportedRuntimeVersion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SupportedRuntimeVersion deserializedSupportedRuntimeVersion = new SupportedRuntimeVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSupportedRuntimeVersion.value = SupportedRuntimeValue.fromString(reader.getString());
                } else if ("platform".equals(fieldName)) {
                    deserializedSupportedRuntimeVersion.platform
                        = SupportedRuntimePlatform.fromString(reader.getString());
                } else if ("version".equals(fieldName)) {
                    deserializedSupportedRuntimeVersion.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSupportedRuntimeVersion;
        });
    }
}
