// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.CustomDomainProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Custom domain resource payload. */
@Fluent
public final class CustomDomainResourceInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CustomDomainResourceInner.class);

    /*
     * Properties of the custom domain resource.
     */
    @JsonProperty(value = "properties")
    private CustomDomainProperties properties;

    /**
     * Get the properties property: Properties of the custom domain resource.
     *
     * @return the properties value.
     */
    public CustomDomainProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the custom domain resource.
     *
     * @param properties the properties value to set.
     * @return the CustomDomainResourceInner object itself.
     */
    public CustomDomainResourceInner withProperties(CustomDomainProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
