// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ApplicationAcceleratorComponent model.
 */
@Fluent
public final class ApplicationAcceleratorComponent implements JsonSerializable<ApplicationAcceleratorComponent> {
    /*
     * The name property.
     */
    private String name;

    /*
     * The resourceRequests property.
     */
    private ApplicationAcceleratorResourceRequests resourceRequests;

    /*
     * The instances property.
     */
    private List<ApplicationAcceleratorInstance> instances;

    /**
     * Creates an instance of ApplicationAcceleratorComponent class.
     */
    public ApplicationAcceleratorComponent() {
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the resourceRequests property: The resourceRequests property.
     * 
     * @return the resourceRequests value.
     */
    public ApplicationAcceleratorResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Set the resourceRequests property: The resourceRequests property.
     * 
     * @param resourceRequests the resourceRequests value to set.
     * @return the ApplicationAcceleratorComponent object itself.
     */
    public ApplicationAcceleratorComponent
        withResourceRequests(ApplicationAcceleratorResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    /**
     * Get the instances property: The instances property.
     * 
     * @return the instances value.
     */
    public List<ApplicationAcceleratorInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceRequests", this.resourceRequests);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationAcceleratorComponent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationAcceleratorComponent if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationAcceleratorComponent.
     */
    public static ApplicationAcceleratorComponent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationAcceleratorComponent deserializedApplicationAcceleratorComponent
                = new ApplicationAcceleratorComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApplicationAcceleratorComponent.name = reader.getString();
                } else if ("resourceRequests".equals(fieldName)) {
                    deserializedApplicationAcceleratorComponent.resourceRequests
                        = ApplicationAcceleratorResourceRequests.fromJson(reader);
                } else if ("instances".equals(fieldName)) {
                    List<ApplicationAcceleratorInstance> instances
                        = reader.readArray(reader1 -> ApplicationAcceleratorInstance.fromJson(reader1));
                    deserializedApplicationAcceleratorComponent.instances = instances;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationAcceleratorComponent;
        });
    }
}
