// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ApplicationAcceleratorInstance model.
 */
@Immutable
public final class ApplicationAcceleratorInstance implements JsonSerializable<ApplicationAcceleratorInstance> {
    /*
     * Name of the Application Accelerator instance.
     */
    private String name;

    /*
     * Status of the Application Accelerator instance. It can be Pending, Running, Succeeded, Failed, Unknown.
     */
    private String status;

    /**
     * Creates an instance of ApplicationAcceleratorInstance class.
     */
    public ApplicationAcceleratorInstance() {
    }

    /**
     * Get the name property: Name of the Application Accelerator instance.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Status of the Application Accelerator instance. It can be Pending, Running, Succeeded,
     * Failed, Unknown.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationAcceleratorInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationAcceleratorInstance if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationAcceleratorInstance.
     */
    public static ApplicationAcceleratorInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationAcceleratorInstance deserializedApplicationAcceleratorInstance
                = new ApplicationAcceleratorInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApplicationAcceleratorInstance.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedApplicationAcceleratorInstance.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationAcceleratorInstance;
        });
    }
}
