// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Custom container user source info.
 */
@Fluent
public final class CustomContainerUserSourceInfo extends UserSourceInfo {
    /*
     * Type of the source uploaded
     */
    private String type = "Container";

    /*
     * Custom container payload
     */
    private CustomContainer customContainer;

    /**
     * Creates an instance of CustomContainerUserSourceInfo class.
     */
    public CustomContainerUserSourceInfo() {
    }

    /**
     * Get the type property: Type of the source uploaded.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the customContainer property: Custom container payload.
     * 
     * @return the customContainer value.
     */
    public CustomContainer customContainer() {
        return this.customContainer;
    }

    /**
     * Set the customContainer property: Custom container payload.
     * 
     * @param customContainer the customContainer value to set.
     * @return the CustomContainerUserSourceInfo object itself.
     */
    public CustomContainerUserSourceInfo withCustomContainer(CustomContainer customContainer) {
        this.customContainer = customContainer;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CustomContainerUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (customContainer() != null) {
            customContainer().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", version());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("customContainer", this.customContainer);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomContainerUserSourceInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomContainerUserSourceInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomContainerUserSourceInfo.
     */
    public static CustomContainerUserSourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomContainerUserSourceInfo deserializedCustomContainerUserSourceInfo
                = new CustomContainerUserSourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedCustomContainerUserSourceInfo.withVersion(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedCustomContainerUserSourceInfo.type = reader.getString();
                } else if ("customContainer".equals(fieldName)) {
                    deserializedCustomContainerUserSourceInfo.customContainer = CustomContainer.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomContainerUserSourceInfo;
        });
    }
}
