// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * API route config of the Spring Cloud Gateway.
 */
@Fluent
public final class GatewayRouteConfigProperties implements JsonSerializable<GatewayRouteConfigProperties> {
    /*
     * State of the Spring Cloud Gateway route config.
     */
    private GatewayProvisioningState provisioningState;

    /*
     * The resource Id of the Azure Spring Apps app, required unless route defines `uri`.
     */
    private String appResourceId;

    /*
     * OpenAPI properties of Spring Cloud Gateway route config.
     */
    private GatewayRouteConfigOpenApiProperties openApi;

    /*
     * Protocol of routed Azure Spring Apps applications.
     */
    private GatewayRouteConfigProtocol protocol;

    /*
     * Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`,
     * `filters`.
     */
    private List<GatewayApiRoute> routes;

    /*
     * Enable Single Sign-On in app level.
     */
    private Boolean ssoEnabled;

    /*
     * A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against
     * request headers and parameter values. All of the predicates associated with a route must evaluate to true for the
     * route to be matched to the request.
     */
    private List<String> predicates;

    /*
     * To modify the request before sending it to the target endpoint, or the received response in app level.
     */
    private List<String> filters;

    /**
     * Creates an instance of GatewayRouteConfigProperties class.
     */
    public GatewayRouteConfigProperties() {
    }

    /**
     * Get the provisioningState property: State of the Spring Cloud Gateway route config.
     * 
     * @return the provisioningState value.
     */
    public GatewayProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the appResourceId property: The resource Id of the Azure Spring Apps app, required unless route defines
     * `uri`.
     * 
     * @return the appResourceId value.
     */
    public String appResourceId() {
        return this.appResourceId;
    }

    /**
     * Set the appResourceId property: The resource Id of the Azure Spring Apps app, required unless route defines
     * `uri`.
     * 
     * @param appResourceId the appResourceId value to set.
     * @return the GatewayRouteConfigProperties object itself.
     */
    public GatewayRouteConfigProperties withAppResourceId(String appResourceId) {
        this.appResourceId = appResourceId;
        return this;
    }

    /**
     * Get the openApi property: OpenAPI properties of Spring Cloud Gateway route config.
     * 
     * @return the openApi value.
     */
    public GatewayRouteConfigOpenApiProperties openApi() {
        return this.openApi;
    }

    /**
     * Set the openApi property: OpenAPI properties of Spring Cloud Gateway route config.
     * 
     * @param openApi the openApi value to set.
     * @return the GatewayRouteConfigProperties object itself.
     */
    public GatewayRouteConfigProperties withOpenApi(GatewayRouteConfigOpenApiProperties openApi) {
        this.openApi = openApi;
        return this;
    }

    /**
     * Get the protocol property: Protocol of routed Azure Spring Apps applications.
     * 
     * @return the protocol value.
     */
    public GatewayRouteConfigProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Protocol of routed Azure Spring Apps applications.
     * 
     * @param protocol the protocol value to set.
     * @return the GatewayRouteConfigProperties object itself.
     */
    public GatewayRouteConfigProperties withProtocol(GatewayRouteConfigProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the routes property: Array of API routes, each route contains properties such as `title`, `uri`,
     * `ssoEnabled`, `predicates`, `filters`.
     * 
     * @return the routes value.
     */
    public List<GatewayApiRoute> routes() {
        return this.routes;
    }

    /**
     * Set the routes property: Array of API routes, each route contains properties such as `title`, `uri`,
     * `ssoEnabled`, `predicates`, `filters`.
     * 
     * @param routes the routes value to set.
     * @return the GatewayRouteConfigProperties object itself.
     */
    public GatewayRouteConfigProperties withRoutes(List<GatewayApiRoute> routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Get the ssoEnabled property: Enable Single Sign-On in app level.
     * 
     * @return the ssoEnabled value.
     */
    public Boolean ssoEnabled() {
        return this.ssoEnabled;
    }

    /**
     * Set the ssoEnabled property: Enable Single Sign-On in app level.
     * 
     * @param ssoEnabled the ssoEnabled value to set.
     * @return the GatewayRouteConfigProperties object itself.
     */
    public GatewayRouteConfigProperties withSsoEnabled(Boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
        return this;
    }

    /**
     * Get the predicates property: A number of conditions to evaluate a route for each request in app level. Each
     * predicate may be evaluated against request headers and parameter values. All of the predicates associated with a
     * route must evaluate to true for the route to be matched to the request.
     * 
     * @return the predicates value.
     */
    public List<String> predicates() {
        return this.predicates;
    }

    /**
     * Set the predicates property: A number of conditions to evaluate a route for each request in app level. Each
     * predicate may be evaluated against request headers and parameter values. All of the predicates associated with a
     * route must evaluate to true for the route to be matched to the request.
     * 
     * @param predicates the predicates value to set.
     * @return the GatewayRouteConfigProperties object itself.
     */
    public GatewayRouteConfigProperties withPredicates(List<String> predicates) {
        this.predicates = predicates;
        return this;
    }

    /**
     * Get the filters property: To modify the request before sending it to the target endpoint, or the received
     * response in app level.
     * 
     * @return the filters value.
     */
    public List<String> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: To modify the request before sending it to the target endpoint, or the received
     * response in app level.
     * 
     * @param filters the filters value to set.
     * @return the GatewayRouteConfigProperties object itself.
     */
    public GatewayRouteConfigProperties withFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (openApi() != null) {
            openApi().validate();
        }
        if (routes() != null) {
            routes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appResourceId", this.appResourceId);
        jsonWriter.writeJsonField("openApi", this.openApi);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("ssoEnabled", this.ssoEnabled);
        jsonWriter.writeArrayField("predicates", this.predicates, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayRouteConfigProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayRouteConfigProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayRouteConfigProperties.
     */
    public static GatewayRouteConfigProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayRouteConfigProperties deserializedGatewayRouteConfigProperties = new GatewayRouteConfigProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.provisioningState
                        = GatewayProvisioningState.fromString(reader.getString());
                } else if ("appResourceId".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.appResourceId = reader.getString();
                } else if ("openApi".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.openApi
                        = GatewayRouteConfigOpenApiProperties.fromJson(reader);
                } else if ("protocol".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.protocol
                        = GatewayRouteConfigProtocol.fromString(reader.getString());
                } else if ("routes".equals(fieldName)) {
                    List<GatewayApiRoute> routes = reader.readArray(reader1 -> GatewayApiRoute.fromJson(reader1));
                    deserializedGatewayRouteConfigProperties.routes = routes;
                } else if ("ssoEnabled".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.ssoEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("predicates".equals(fieldName)) {
                    List<String> predicates = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayRouteConfigProperties.predicates = predicates;
                } else if ("filters".equals(fieldName)) {
                    List<String> filters = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayRouteConfigProperties.filters = filters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayRouteConfigProperties;
        });
    }
}
