// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The action of the probe.
 */
@Immutable
public class ProbeAction implements JsonSerializable<ProbeAction> {
    /*
     * The type of the action to take to perform the health check.
     */
    private ProbeActionType type = ProbeActionType.fromString("ProbeAction");

    /**
     * Creates an instance of ProbeAction class.
     */
    public ProbeAction() {
    }

    /**
     * Get the type property: The type of the action to take to perform the health check.
     * 
     * @return the type value.
     */
    public ProbeActionType type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProbeAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProbeAction if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProbeAction.
     */
    public static ProbeAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("HTTPGetAction".equals(discriminatorValue)) {
                    return HttpGetAction.fromJson(readerToUse.reset());
                } else if ("ExecAction".equals(discriminatorValue)) {
                    return ExecAction.fromJson(readerToUse.reset());
                } else if ("TCPSocketAction".equals(discriminatorValue)) {
                    return TcpSocketAction.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static ProbeAction fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProbeAction deserializedProbeAction = new ProbeAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedProbeAction.type = ProbeActionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProbeAction;
        });
    }
}
