/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.HttpSchemeType;
import com.azure.resourcemanager.appplatform.models.ProbeAction;
import com.azure.resourcemanager.appplatform.models.ProbeActionType;
import java.io.IOException;

public final class HttpGetAction
extends ProbeAction {
    private ProbeActionType type = ProbeActionType.HTTPGET_ACTION;
    private String path;
    private HttpSchemeType scheme;

    @Override
    public ProbeActionType type() {
        return this.type;
    }

    public String path() {
        return this.path;
    }

    public HttpGetAction withPath(String path) {
        this.path = path;
        return this;
    }

    public HttpSchemeType scheme() {
        return this.scheme;
    }

    public HttpGetAction withScheme(HttpSchemeType scheme) {
        this.scheme = scheme;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("scheme", this.scheme == null ? null : this.scheme.toString());
        return jsonWriter.writeEndObject();
    }

    public static HttpGetAction fromJson(JsonReader jsonReader) throws IOException {
        return (HttpGetAction)jsonReader.readObject(reader -> {
            HttpGetAction deserializedHttpGetAction = new HttpGetAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedHttpGetAction.type = ProbeActionType.fromString(reader.getString());
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedHttpGetAction.path = reader.getString();
                    continue;
                }
                if ("scheme".equals(fieldName)) {
                    deserializedHttpGetAction.scheme = HttpSchemeType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpGetAction;
        });
    }
}

