// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Collection of instances belong to the Application Live View.
 */
@Immutable
public final class ApplicationLiveViewInstance implements JsonSerializable<ApplicationLiveViewInstance> {
    /*
     * Name of the Application Live View instance.
     */
    private String name;

    /*
     * Status of the Application Live View instance. It can be Pending, Running, Succeeded, Failed, Unknown.
     */
    private String status;

    /**
     * Creates an instance of ApplicationLiveViewInstance class.
     */
    public ApplicationLiveViewInstance() {
    }

    /**
     * Get the name property: Name of the Application Live View instance.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Status of the Application Live View instance. It can be Pending, Running, Succeeded,
     * Failed, Unknown.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationLiveViewInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationLiveViewInstance if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationLiveViewInstance.
     */
    public static ApplicationLiveViewInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationLiveViewInstance deserializedApplicationLiveViewInstance = new ApplicationLiveViewInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApplicationLiveViewInstance.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedApplicationLiveViewInstance.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationLiveViewInstance;
        });
    }
}
