// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of the action to take to perform the health check.
 */
public final class ProbeActionType extends ExpandableStringEnum<ProbeActionType> {
    /**
     * Static value HTTPGetAction for ProbeActionType.
     */
    public static final ProbeActionType HTTPGET_ACTION = fromString("HTTPGetAction");

    /**
     * Static value TCPSocketAction for ProbeActionType.
     */
    public static final ProbeActionType TCPSOCKET_ACTION = fromString("TCPSocketAction");

    /**
     * Static value ExecAction for ProbeActionType.
     */
    public static final ProbeActionType EXEC_ACTION = fromString("ExecAction");

    /**
     * Creates a new instance of ProbeActionType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ProbeActionType() {
    }

    /**
     * Creates or finds a ProbeActionType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ProbeActionType.
     */
    public static ProbeActionType fromString(String name) {
        return fromString(name, ProbeActionType.class);
    }

    /**
     * Gets known ProbeActionType values.
     * 
     * @return known ProbeActionType values.
     */
    public static Collection<ProbeActionType> values() {
        return values(ProbeActionType.class);
    }
}
