// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Uploaded Java source code binary for a deployment.
 */
@Fluent
public final class SourceUploadedUserSourceInfo extends UploadedUserSourceInfo {
    /*
     * Type of the source uploaded
     */
    private String type = "Source";

    /*
     * Selector for the artifact to be used for the deployment for multi-module projects. This should be
     * the relative path to the target module/project.
     */
    private String artifactSelector;

    /*
     * Runtime version of the source file
     */
    private String runtimeVersion;

    /**
     * Creates an instance of SourceUploadedUserSourceInfo class.
     */
    public SourceUploadedUserSourceInfo() {
    }

    /**
     * Get the type property: Type of the source uploaded.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the artifactSelector property: Selector for the artifact to be used for the deployment for multi-module
     * projects. This should be
     * the relative path to the target module/project.
     * 
     * @return the artifactSelector value.
     */
    public String artifactSelector() {
        return this.artifactSelector;
    }

    /**
     * Set the artifactSelector property: Selector for the artifact to be used for the deployment for multi-module
     * projects. This should be
     * the relative path to the target module/project.
     * 
     * @param artifactSelector the artifactSelector value to set.
     * @return the SourceUploadedUserSourceInfo object itself.
     */
    public SourceUploadedUserSourceInfo withArtifactSelector(String artifactSelector) {
        this.artifactSelector = artifactSelector;
        return this;
    }

    /**
     * Get the runtimeVersion property: Runtime version of the source file.
     * 
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: Runtime version of the source file.
     * 
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the SourceUploadedUserSourceInfo object itself.
     */
    public SourceUploadedUserSourceInfo withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SourceUploadedUserSourceInfo withRelativePath(String relativePath) {
        super.withRelativePath(relativePath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SourceUploadedUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", version());
        jsonWriter.writeStringField("relativePath", relativePath());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("artifactSelector", this.artifactSelector);
        jsonWriter.writeStringField("runtimeVersion", this.runtimeVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceUploadedUserSourceInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceUploadedUserSourceInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SourceUploadedUserSourceInfo.
     */
    public static SourceUploadedUserSourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceUploadedUserSourceInfo deserializedSourceUploadedUserSourceInfo = new SourceUploadedUserSourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedSourceUploadedUserSourceInfo.withVersion(reader.getString());
                } else if ("relativePath".equals(fieldName)) {
                    deserializedSourceUploadedUserSourceInfo.withRelativePath(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedSourceUploadedUserSourceInfo.type = reader.getString();
                } else if ("artifactSelector".equals(fieldName)) {
                    deserializedSourceUploadedUserSourceInfo.artifactSelector = reader.getString();
                } else if ("runtimeVersion".equals(fieldName)) {
                    deserializedSourceUploadedUserSourceInfo.runtimeVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceUploadedUserSourceInfo;
        });
    }
}
