// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Source information for a deployment.
 */
@Fluent
public class UserSourceInfo implements JsonSerializable<UserSourceInfo> {
    /*
     * Type of the source uploaded
     */
    private String type = "UserSourceInfo";

    /*
     * Version of the source
     */
    private String version;

    /**
     * Creates an instance of UserSourceInfo class.
     */
    public UserSourceInfo() {
    }

    /**
     * Get the type property: Type of the source uploaded.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the version property: Version of the source.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: Version of the source.
     * 
     * @param version the version value to set.
     * @return the UserSourceInfo object itself.
     */
    public UserSourceInfo withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserSourceInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserSourceInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserSourceInfo.
     */
    public static UserSourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("UploadedUserSourceInfo".equals(discriminatorValue)) {
                    return UploadedUserSourceInfo.fromJsonKnownDiscriminator(readerToUse.reset());
                } else if ("Jar".equals(discriminatorValue)) {
                    return JarUploadedUserSourceInfo.fromJson(readerToUse.reset());
                } else if ("War".equals(discriminatorValue)) {
                    return WarUploadedUserSourceInfo.fromJson(readerToUse.reset());
                } else if ("Source".equals(discriminatorValue)) {
                    return SourceUploadedUserSourceInfo.fromJson(readerToUse.reset());
                } else if ("NetCoreZip".equals(discriminatorValue)) {
                    return NetCoreZipUploadedUserSourceInfo.fromJson(readerToUse.reset());
                } else if ("BuildResult".equals(discriminatorValue)) {
                    return BuildResultUserSourceInfo.fromJson(readerToUse.reset());
                } else if ("Container".equals(discriminatorValue)) {
                    return CustomContainerUserSourceInfo.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static UserSourceInfo fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserSourceInfo deserializedUserSourceInfo = new UserSourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedUserSourceInfo.type = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedUserSourceInfo.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserSourceInfo;
        });
    }
}
