/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.CustomPersistentDiskProperties;
import java.io.IOException;

public final class CustomPersistentDiskResource
implements JsonSerializable<CustomPersistentDiskResource> {
    private CustomPersistentDiskProperties customPersistentDiskProperties;
    private String storageId;
    private static final ClientLogger LOGGER = new ClientLogger(CustomPersistentDiskResource.class);

    public CustomPersistentDiskProperties customPersistentDiskProperties() {
        return this.customPersistentDiskProperties;
    }

    public CustomPersistentDiskResource withCustomPersistentDiskProperties(CustomPersistentDiskProperties customPersistentDiskProperties) {
        this.customPersistentDiskProperties = customPersistentDiskProperties;
        return this;
    }

    public String storageId() {
        return this.storageId;
    }

    public CustomPersistentDiskResource withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public void validate() {
        if (this.customPersistentDiskProperties() != null) {
            this.customPersistentDiskProperties().validate();
        }
        if (this.storageId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageId in model CustomPersistentDiskResource"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageId", this.storageId);
        jsonWriter.writeJsonField("customPersistentDiskProperties", (JsonSerializable)this.customPersistentDiskProperties);
        return jsonWriter.writeEndObject();
    }

    public static CustomPersistentDiskResource fromJson(JsonReader jsonReader) throws IOException {
        return (CustomPersistentDiskResource)jsonReader.readObject(reader -> {
            CustomPersistentDiskResource deserializedCustomPersistentDiskResource = new CustomPersistentDiskResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageId".equals(fieldName)) {
                    deserializedCustomPersistentDiskResource.storageId = reader.getString();
                    continue;
                }
                if ("customPersistentDiskProperties".equals(fieldName)) {
                    deserializedCustomPersistentDiskResource.customPersistentDiskProperties = CustomPersistentDiskProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomPersistentDiskResource;
        });
    }
}

