// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ConfigServerSettingsErrorRecord;
import java.io.IOException;
import java.util.List;

/**
 * Validation result for config server settings.
 */
@Fluent
public final class ConfigServerSettingsValidateResultInner
    implements JsonSerializable<ConfigServerSettingsValidateResultInner> {
    /*
     * Indicate if the config server settings are valid
     */
    private Boolean isValid;

    /*
     * The detail validation results
     */
    private List<ConfigServerSettingsErrorRecord> details;

    /**
     * Creates an instance of ConfigServerSettingsValidateResultInner class.
     */
    public ConfigServerSettingsValidateResultInner() {
    }

    /**
     * Get the isValid property: Indicate if the config server settings are valid.
     * 
     * @return the isValid value.
     */
    public Boolean isValid() {
        return this.isValid;
    }

    /**
     * Set the isValid property: Indicate if the config server settings are valid.
     * 
     * @param isValid the isValid value to set.
     * @return the ConfigServerSettingsValidateResultInner object itself.
     */
    public ConfigServerSettingsValidateResultInner withIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    /**
     * Get the details property: The detail validation results.
     * 
     * @return the details value.
     */
    public List<ConfigServerSettingsErrorRecord> details() {
        return this.details;
    }

    /**
     * Set the details property: The detail validation results.
     * 
     * @param details the details value to set.
     * @return the ConfigServerSettingsValidateResultInner object itself.
     */
    public ConfigServerSettingsValidateResultInner withDetails(List<ConfigServerSettingsErrorRecord> details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (details() != null) {
            details().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isValid", this.isValid);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigServerSettingsValidateResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigServerSettingsValidateResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigServerSettingsValidateResultInner.
     */
    public static ConfigServerSettingsValidateResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigServerSettingsValidateResultInner deserializedConfigServerSettingsValidateResultInner
                = new ConfigServerSettingsValidateResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isValid".equals(fieldName)) {
                    deserializedConfigServerSettingsValidateResultInner.isValid
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("details".equals(fieldName)) {
                    List<ConfigServerSettingsErrorRecord> details
                        = reader.readArray(reader1 -> ConfigServerSettingsErrorRecord.fromJson(reader1));
                    deserializedConfigServerSettingsValidateResultInner.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigServerSettingsValidateResultInner;
        });
    }
}
