// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ApplicationAcceleratorResourceRequests model.
 */
@Immutable
public final class ApplicationAcceleratorResourceRequests
    implements JsonSerializable<ApplicationAcceleratorResourceRequests> {
    /*
     * Cpu allocated to each application accelerator component. 1 core can be represented by 1 or 1000m
     */
    private String cpu;

    /*
     * Memory allocated to each application accelerator component. 1 GB can be represented by 1Gi or 1024Mi.
     */
    private String memory;

    /*
     * Instance count of the application accelerator component.
     */
    private Integer instanceCount;

    /**
     * Creates an instance of ApplicationAcceleratorResourceRequests class.
     */
    public ApplicationAcceleratorResourceRequests() {
    }

    /**
     * Get the cpu property: Cpu allocated to each application accelerator component. 1 core can be represented by 1 or
     * 1000m.
     * 
     * @return the cpu value.
     */
    public String cpu() {
        return this.cpu;
    }

    /**
     * Get the memory property: Memory allocated to each application accelerator component. 1 GB can be represented by
     * 1Gi or 1024Mi.
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Get the instanceCount property: Instance count of the application accelerator component.
     * 
     * @return the instanceCount value.
     */
    public Integer instanceCount() {
        return this.instanceCount;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationAcceleratorResourceRequests from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationAcceleratorResourceRequests if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationAcceleratorResourceRequests.
     */
    public static ApplicationAcceleratorResourceRequests fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationAcceleratorResourceRequests deserializedApplicationAcceleratorResourceRequests
                = new ApplicationAcceleratorResourceRequests();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpu".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceRequests.cpu = reader.getString();
                } else if ("memory".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceRequests.memory = reader.getString();
                } else if ("instanceCount".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceRequests.instanceCount
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationAcceleratorResourceRequests;
        });
    }
}
