// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Application Insights agent versions properties payload.
 */
@Immutable
public final class ApplicationInsightsAgentVersions implements JsonSerializable<ApplicationInsightsAgentVersions> {
    /*
     * Indicates the version of application insight java agent
     */
    private String java;

    /**
     * Creates an instance of ApplicationInsightsAgentVersions class.
     */
    public ApplicationInsightsAgentVersions() {
    }

    /**
     * Get the java property: Indicates the version of application insight java agent.
     * 
     * @return the java value.
     */
    public String java() {
        return this.java;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationInsightsAgentVersions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationInsightsAgentVersions if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationInsightsAgentVersions.
     */
    public static ApplicationInsightsAgentVersions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationInsightsAgentVersions deserializedApplicationInsightsAgentVersions
                = new ApplicationInsightsAgentVersions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("java".equals(fieldName)) {
                    deserializedApplicationInsightsAgentVersions.java = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationInsightsAgentVersions;
        });
    }
}
