// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Build service agent pool properties.
 */
@Fluent
public final class BuildServiceAgentPoolProperties implements JsonSerializable<BuildServiceAgentPoolProperties> {
    /*
     * Provisioning state of the build service agent pool
     */
    private String provisioningState;

    /*
     * build service agent pool size properties
     */
    private BuildServiceAgentPoolSizeProperties poolSize;

    /**
     * Creates an instance of BuildServiceAgentPoolProperties class.
     */
    public BuildServiceAgentPoolProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the build service agent pool.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the poolSize property: build service agent pool size properties.
     * 
     * @return the poolSize value.
     */
    public BuildServiceAgentPoolSizeProperties poolSize() {
        return this.poolSize;
    }

    /**
     * Set the poolSize property: build service agent pool size properties.
     * 
     * @param poolSize the poolSize value to set.
     * @return the BuildServiceAgentPoolProperties object itself.
     */
    public BuildServiceAgentPoolProperties withPoolSize(BuildServiceAgentPoolSizeProperties poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (poolSize() != null) {
            poolSize().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("poolSize", this.poolSize);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildServiceAgentPoolProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildServiceAgentPoolProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildServiceAgentPoolProperties.
     */
    public static BuildServiceAgentPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildServiceAgentPoolProperties deserializedBuildServiceAgentPoolProperties
                = new BuildServiceAgentPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedBuildServiceAgentPoolProperties.provisioningState = reader.getString();
                } else if ("poolSize".equals(fieldName)) {
                    deserializedBuildServiceAgentPoolProperties.poolSize
                        = BuildServiceAgentPoolSizeProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildServiceAgentPoolProperties;
        });
    }
}
