// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Custom domain validate payload.
 */
@Fluent
public final class CustomDomainValidatePayload implements JsonSerializable<CustomDomainValidatePayload> {
    /*
     * Name to be validated
     */
    private String name;

    /**
     * Creates an instance of CustomDomainValidatePayload class.
     */
    public CustomDomainValidatePayload() {
    }

    /**
     * Get the name property: Name to be validated.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name to be validated.
     * 
     * @param name the name value to set.
     * @return the CustomDomainValidatePayload object itself.
     */
    public CustomDomainValidatePayload withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model CustomDomainValidatePayload"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomDomainValidatePayload.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDomainValidatePayload from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDomainValidatePayload if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomDomainValidatePayload.
     */
    public static CustomDomainValidatePayload fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomainValidatePayload deserializedCustomDomainValidatePayload = new CustomDomainValidatePayload();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCustomDomainValidatePayload.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDomainValidatePayload;
        });
    }
}
