// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * API route config of the Spring Cloud Gateway.
 */
@Fluent
public final class GatewayApiRoute implements JsonSerializable<GatewayApiRoute> {
    /*
     * A title, will be applied to methods in the generated OpenAPI documentation.
     */
    private String title;

    /*
     * A description, will be applied to methods in the generated OpenAPI documentation.
     */
    private String description;

    /*
     * Full uri, will override `appName`.
     */
    private String uri;

    /*
     * Enable sso validation.
     */
    private Boolean ssoEnabled;

    /*
     * Pass currently-authenticated user's identity token to application service, default is 'false'
     */
    private Boolean tokenRelay;

    /*
     * A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request
     * headers and parameter values. All of the predicates associated with a route must evaluate to true for the route
     * to be matched to the request.
     */
    private List<String> predicates;

    /*
     * To modify the request before sending it to the target endpoint, or the received response.
     */
    private List<String> filters;

    /*
     * Route processing order.
     */
    private Integer order;

    /*
     * Classification tags, will be applied to methods in the generated OpenAPI documentation.
     */
    private List<String> tags;

    /**
     * Creates an instance of GatewayApiRoute class.
     */
    public GatewayApiRoute() {
    }

    /**
     * Get the title property: A title, will be applied to methods in the generated OpenAPI documentation.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: A title, will be applied to methods in the generated OpenAPI documentation.
     * 
     * @param title the title value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: A description, will be applied to methods in the generated OpenAPI documentation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description, will be applied to methods in the generated OpenAPI documentation.
     * 
     * @param description the description value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the uri property: Full uri, will override `appName`.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: Full uri, will override `appName`.
     * 
     * @param uri the uri value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the ssoEnabled property: Enable sso validation.
     * 
     * @return the ssoEnabled value.
     */
    public Boolean ssoEnabled() {
        return this.ssoEnabled;
    }

    /**
     * Set the ssoEnabled property: Enable sso validation.
     * 
     * @param ssoEnabled the ssoEnabled value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withSsoEnabled(Boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
        return this;
    }

    /**
     * Get the tokenRelay property: Pass currently-authenticated user's identity token to application service, default
     * is 'false'.
     * 
     * @return the tokenRelay value.
     */
    public Boolean tokenRelay() {
        return this.tokenRelay;
    }

    /**
     * Set the tokenRelay property: Pass currently-authenticated user's identity token to application service, default
     * is 'false'.
     * 
     * @param tokenRelay the tokenRelay value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withTokenRelay(Boolean tokenRelay) {
        this.tokenRelay = tokenRelay;
        return this;
    }

    /**
     * Get the predicates property: A number of conditions to evaluate a route for each request. Each predicate may be
     * evaluated against request headers and parameter values. All of the predicates associated with a route must
     * evaluate to true for the route to be matched to the request.
     * 
     * @return the predicates value.
     */
    public List<String> predicates() {
        return this.predicates;
    }

    /**
     * Set the predicates property: A number of conditions to evaluate a route for each request. Each predicate may be
     * evaluated against request headers and parameter values. All of the predicates associated with a route must
     * evaluate to true for the route to be matched to the request.
     * 
     * @param predicates the predicates value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withPredicates(List<String> predicates) {
        this.predicates = predicates;
        return this;
    }

    /**
     * Get the filters property: To modify the request before sending it to the target endpoint, or the received
     * response.
     * 
     * @return the filters value.
     */
    public List<String> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: To modify the request before sending it to the target endpoint, or the received
     * response.
     * 
     * @param filters the filters value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Get the order property: Route processing order.
     * 
     * @return the order value.
     */
    public Integer order() {
        return this.order;
    }

    /**
     * Set the order property: Route processing order.
     * 
     * @param order the order value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withOrder(Integer order) {
        this.order = order;
        return this;
    }

    /**
     * Get the tags property: Classification tags, will be applied to methods in the generated OpenAPI documentation.
     * 
     * @return the tags value.
     */
    public List<String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Classification tags, will be applied to methods in the generated OpenAPI documentation.
     * 
     * @param tags the tags value to set.
     * @return the GatewayApiRoute object itself.
     */
    public GatewayApiRoute withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeBooleanField("ssoEnabled", this.ssoEnabled);
        jsonWriter.writeBooleanField("tokenRelay", this.tokenRelay);
        jsonWriter.writeArrayField("predicates", this.predicates, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("order", this.order);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayApiRoute from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayApiRoute if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayApiRoute.
     */
    public static GatewayApiRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayApiRoute deserializedGatewayApiRoute = new GatewayApiRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedGatewayApiRoute.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedGatewayApiRoute.description = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    deserializedGatewayApiRoute.uri = reader.getString();
                } else if ("ssoEnabled".equals(fieldName)) {
                    deserializedGatewayApiRoute.ssoEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("tokenRelay".equals(fieldName)) {
                    deserializedGatewayApiRoute.tokenRelay = reader.getNullable(JsonReader::getBoolean);
                } else if ("predicates".equals(fieldName)) {
                    List<String> predicates = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayApiRoute.predicates = predicates;
                } else if ("filters".equals(fieldName)) {
                    List<String> filters = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayApiRoute.filters = filters;
                } else if ("order".equals(fieldName)) {
                    deserializedGatewayApiRoute.order = reader.getNullable(JsonReader::getInt);
                } else if ("tags".equals(fieldName)) {
                    List<String> tags = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayApiRoute.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayApiRoute;
        });
    }
}
