// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Git repository property payload for config server.
 */
@Fluent
public final class GitPatternRepository implements JsonSerializable<GitPatternRepository> {
    /*
     * Name of the repository
     */
    private String name;

    /*
     * Collection of pattern of the repository
     */
    private List<String> pattern;

    /*
     * URI of the repository
     */
    private String uri;

    /*
     * Label of the repository
     */
    private String label;

    /*
     * Searching path of the repository
     */
    private List<String> searchPaths;

    /*
     * Username of git repository basic auth.
     */
    private String username;

    /*
     * Password of git repository basic auth.
     */
    private String password;

    /*
     * Public sshKey of git repository.
     */
    private String hostKey;

    /*
     * SshKey algorithm of git repository.
     */
    private String hostKeyAlgorithm;

    /*
     * Private sshKey algorithm of git repository.
     */
    private String privateKey;

    /*
     * Strict host key checking or not.
     */
    private Boolean strictHostKeyChecking;

    /**
     * Creates an instance of GitPatternRepository class.
     */
    public GitPatternRepository() {
    }

    /**
     * Get the name property: Name of the repository.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the repository.
     * 
     * @param name the name value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the pattern property: Collection of pattern of the repository.
     * 
     * @return the pattern value.
     */
    public List<String> pattern() {
        return this.pattern;
    }

    /**
     * Set the pattern property: Collection of pattern of the repository.
     * 
     * @param pattern the pattern value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withPattern(List<String> pattern) {
        this.pattern = pattern;
        return this;
    }

    /**
     * Get the uri property: URI of the repository.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: URI of the repository.
     * 
     * @param uri the uri value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the label property: Label of the repository.
     * 
     * @return the label value.
     */
    public String label() {
        return this.label;
    }

    /**
     * Set the label property: Label of the repository.
     * 
     * @param label the label value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the searchPaths property: Searching path of the repository.
     * 
     * @return the searchPaths value.
     */
    public List<String> searchPaths() {
        return this.searchPaths;
    }

    /**
     * Set the searchPaths property: Searching path of the repository.
     * 
     * @param searchPaths the searchPaths value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withSearchPaths(List<String> searchPaths) {
        this.searchPaths = searchPaths;
        return this;
    }

    /**
     * Get the username property: Username of git repository basic auth.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: Username of git repository basic auth.
     * 
     * @param username the username value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password of git repository basic auth.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: Password of git repository basic auth.
     * 
     * @param password the password value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the hostKey property: Public sshKey of git repository.
     * 
     * @return the hostKey value.
     */
    public String hostKey() {
        return this.hostKey;
    }

    /**
     * Set the hostKey property: Public sshKey of git repository.
     * 
     * @param hostKey the hostKey value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withHostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    /**
     * Get the hostKeyAlgorithm property: SshKey algorithm of git repository.
     * 
     * @return the hostKeyAlgorithm value.
     */
    public String hostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    /**
     * Set the hostKeyAlgorithm property: SshKey algorithm of git repository.
     * 
     * @param hostKeyAlgorithm the hostKeyAlgorithm value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
        return this;
    }

    /**
     * Get the privateKey property: Private sshKey algorithm of git repository.
     * 
     * @return the privateKey value.
     */
    public String privateKey() {
        return this.privateKey;
    }

    /**
     * Set the privateKey property: Private sshKey algorithm of git repository.
     * 
     * @param privateKey the privateKey value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    /**
     * Get the strictHostKeyChecking property: Strict host key checking or not.
     * 
     * @return the strictHostKeyChecking value.
     */
    public Boolean strictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    /**
     * Set the strictHostKeyChecking property: Strict host key checking or not.
     * 
     * @param strictHostKeyChecking the strictHostKeyChecking value to set.
     * @return the GitPatternRepository object itself.
     */
    public GitPatternRepository withStrictHostKeyChecking(Boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model GitPatternRepository"));
        }
        if (uri() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property uri in model GitPatternRepository"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GitPatternRepository.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeArrayField("pattern", this.pattern, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeArrayField("searchPaths", this.searchPaths, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("hostKey", this.hostKey);
        jsonWriter.writeStringField("hostKeyAlgorithm", this.hostKeyAlgorithm);
        jsonWriter.writeStringField("privateKey", this.privateKey);
        jsonWriter.writeBooleanField("strictHostKeyChecking", this.strictHostKeyChecking);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GitPatternRepository from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GitPatternRepository if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GitPatternRepository.
     */
    public static GitPatternRepository fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GitPatternRepository deserializedGitPatternRepository = new GitPatternRepository();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedGitPatternRepository.name = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    deserializedGitPatternRepository.uri = reader.getString();
                } else if ("pattern".equals(fieldName)) {
                    List<String> pattern = reader.readArray(reader1 -> reader1.getString());
                    deserializedGitPatternRepository.pattern = pattern;
                } else if ("label".equals(fieldName)) {
                    deserializedGitPatternRepository.label = reader.getString();
                } else if ("searchPaths".equals(fieldName)) {
                    List<String> searchPaths = reader.readArray(reader1 -> reader1.getString());
                    deserializedGitPatternRepository.searchPaths = searchPaths;
                } else if ("username".equals(fieldName)) {
                    deserializedGitPatternRepository.username = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedGitPatternRepository.password = reader.getString();
                } else if ("hostKey".equals(fieldName)) {
                    deserializedGitPatternRepository.hostKey = reader.getString();
                } else if ("hostKeyAlgorithm".equals(fieldName)) {
                    deserializedGitPatternRepository.hostKeyAlgorithm = reader.getString();
                } else if ("privateKey".equals(fieldName)) {
                    deserializedGitPatternRepository.privateKey = reader.getString();
                } else if ("strictHostKeyChecking".equals(fieldName)) {
                    deserializedGitPatternRepository.strictHostKeyChecking = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGitPatternRepository;
        });
    }
}
