// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of certificate imported from key vault.
 */
@Fluent
public final class KeyVaultCertificateProperties extends CertificateProperties {
    /*
     * The type of the certificate source.
     */
    private String type = "KeyVaultCertificate";

    /*
     * The vault uri of user key vault.
     */
    private String vaultUri;

    /*
     * The certificate name of key vault.
     */
    private String keyVaultCertName;

    /*
     * The certificate version of key vault.
     */
    private String certVersion;

    /*
     * Optional. If set to true, it will not import private key from key vault.
     */
    private Boolean excludePrivateKey;

    /*
     * Indicates whether to automatically synchronize certificate from key vault or not.
     */
    private KeyVaultCertificateAutoSync autoSync;

    /*
     * The thumbprint of certificate.
     */
    private String thumbprint;

    /*
     * The issuer of certificate.
     */
    private String issuer;

    /*
     * The issue date of certificate.
     */
    private String issuedDate;

    /*
     * The expiration date of certificate.
     */
    private String expirationDate;

    /*
     * The activate date of certificate.
     */
    private String activateDate;

    /*
     * The subject name of certificate.
     */
    private String subjectName;

    /*
     * The domain list of certificate.
     */
    private List<String> dnsNames;

    /*
     * Provisioning state of the Certificate
     */
    private CertificateResourceProvisioningState provisioningState;

    /**
     * Creates an instance of KeyVaultCertificateProperties class.
     */
    public KeyVaultCertificateProperties() {
    }

    /**
     * Get the type property: The type of the certificate source.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the vaultUri property: The vault uri of user key vault.
     * 
     * @return the vaultUri value.
     */
    public String vaultUri() {
        return this.vaultUri;
    }

    /**
     * Set the vaultUri property: The vault uri of user key vault.
     * 
     * @param vaultUri the vaultUri value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withVaultUri(String vaultUri) {
        this.vaultUri = vaultUri;
        return this;
    }

    /**
     * Get the keyVaultCertName property: The certificate name of key vault.
     * 
     * @return the keyVaultCertName value.
     */
    public String keyVaultCertName() {
        return this.keyVaultCertName;
    }

    /**
     * Set the keyVaultCertName property: The certificate name of key vault.
     * 
     * @param keyVaultCertName the keyVaultCertName value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withKeyVaultCertName(String keyVaultCertName) {
        this.keyVaultCertName = keyVaultCertName;
        return this;
    }

    /**
     * Get the certVersion property: The certificate version of key vault.
     * 
     * @return the certVersion value.
     */
    public String certVersion() {
        return this.certVersion;
    }

    /**
     * Set the certVersion property: The certificate version of key vault.
     * 
     * @param certVersion the certVersion value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withCertVersion(String certVersion) {
        this.certVersion = certVersion;
        return this;
    }

    /**
     * Get the excludePrivateKey property: Optional. If set to true, it will not import private key from key vault.
     * 
     * @return the excludePrivateKey value.
     */
    public Boolean excludePrivateKey() {
        return this.excludePrivateKey;
    }

    /**
     * Set the excludePrivateKey property: Optional. If set to true, it will not import private key from key vault.
     * 
     * @param excludePrivateKey the excludePrivateKey value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withExcludePrivateKey(Boolean excludePrivateKey) {
        this.excludePrivateKey = excludePrivateKey;
        return this;
    }

    /**
     * Get the autoSync property: Indicates whether to automatically synchronize certificate from key vault or not.
     * 
     * @return the autoSync value.
     */
    public KeyVaultCertificateAutoSync autoSync() {
        return this.autoSync;
    }

    /**
     * Set the autoSync property: Indicates whether to automatically synchronize certificate from key vault or not.
     * 
     * @param autoSync the autoSync value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withAutoSync(KeyVaultCertificateAutoSync autoSync) {
        this.autoSync = autoSync;
        return this;
    }

    /**
     * Get the thumbprint property: The thumbprint of certificate.
     * 
     * @return the thumbprint value.
     */
    @Override
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Get the issuer property: The issuer of certificate.
     * 
     * @return the issuer value.
     */
    @Override
    public String issuer() {
        return this.issuer;
    }

    /**
     * Get the issuedDate property: The issue date of certificate.
     * 
     * @return the issuedDate value.
     */
    @Override
    public String issuedDate() {
        return this.issuedDate;
    }

    /**
     * Get the expirationDate property: The expiration date of certificate.
     * 
     * @return the expirationDate value.
     */
    @Override
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Get the activateDate property: The activate date of certificate.
     * 
     * @return the activateDate value.
     */
    @Override
    public String activateDate() {
        return this.activateDate;
    }

    /**
     * Get the subjectName property: The subject name of certificate.
     * 
     * @return the subjectName value.
     */
    @Override
    public String subjectName() {
        return this.subjectName;
    }

    /**
     * Get the dnsNames property: The domain list of certificate.
     * 
     * @return the dnsNames value.
     */
    @Override
    public List<String> dnsNames() {
        return this.dnsNames;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Certificate.
     * 
     * @return the provisioningState value.
     */
    @Override
    public CertificateResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (vaultUri() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property vaultUri in model KeyVaultCertificateProperties"));
        }
        if (keyVaultCertName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyVaultCertName in model KeyVaultCertificateProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultCertificateProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vaultUri", this.vaultUri);
        jsonWriter.writeStringField("keyVaultCertName", this.keyVaultCertName);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("certVersion", this.certVersion);
        jsonWriter.writeBooleanField("excludePrivateKey", this.excludePrivateKey);
        jsonWriter.writeStringField("autoSync", this.autoSync == null ? null : this.autoSync.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultCertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultCertificateProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVaultCertificateProperties.
     */
    public static KeyVaultCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultCertificateProperties deserializedKeyVaultCertificateProperties
                = new KeyVaultCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("thumbprint".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.thumbprint = reader.getString();
                } else if ("issuer".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.issuer = reader.getString();
                } else if ("issuedDate".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.issuedDate = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.expirationDate = reader.getString();
                } else if ("activateDate".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.activateDate = reader.getString();
                } else if ("subjectName".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.subjectName = reader.getString();
                } else if ("dnsNames".equals(fieldName)) {
                    List<String> dnsNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedKeyVaultCertificateProperties.dnsNames = dnsNames;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.provisioningState
                        = CertificateResourceProvisioningState.fromString(reader.getString());
                } else if ("vaultUri".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.vaultUri = reader.getString();
                } else if ("keyVaultCertName".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.keyVaultCertName = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.type = reader.getString();
                } else if ("certVersion".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.certVersion = reader.getString();
                } else if ("excludePrivateKey".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.excludePrivateKey
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("autoSync".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.autoSync
                        = KeyVaultCertificateAutoSync.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultCertificateProperties;
        });
    }
}
