/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.BuilderProvisioningState;
import com.azure.resourcemanager.appplatform.models.BuildpacksGroupProperties;
import com.azure.resourcemanager.appplatform.models.StackProperties;
import java.io.IOException;
import java.util.List;

public final class BuilderProperties
implements JsonSerializable<BuilderProperties> {
    private BuilderProvisioningState provisioningState;
    private StackProperties stack;
    private List<BuildpacksGroupProperties> buildpackGroups;

    public BuilderProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public StackProperties stack() {
        return this.stack;
    }

    public BuilderProperties withStack(StackProperties stack) {
        this.stack = stack;
        return this;
    }

    public List<BuildpacksGroupProperties> buildpackGroups() {
        return this.buildpackGroups;
    }

    public BuilderProperties withBuildpackGroups(List<BuildpacksGroupProperties> buildpackGroups) {
        this.buildpackGroups = buildpackGroups;
        return this;
    }

    public void validate() {
        if (this.stack() != null) {
            this.stack().validate();
        }
        if (this.buildpackGroups() != null) {
            this.buildpackGroups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("stack", (JsonSerializable)this.stack);
        jsonWriter.writeArrayField("buildpackGroups", this.buildpackGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BuilderProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BuilderProperties)jsonReader.readObject(reader -> {
            BuilderProperties deserializedBuilderProperties = new BuilderProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedBuilderProperties.provisioningState = BuilderProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("stack".equals(fieldName)) {
                    deserializedBuilderProperties.stack = StackProperties.fromJson(reader);
                    continue;
                }
                if ("buildpackGroups".equals(fieldName)) {
                    List buildpackGroups;
                    deserializedBuilderProperties.buildpackGroups = buildpackGroups = reader.readArray(reader1 -> BuildpacksGroupProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuilderProperties;
        });
    }
}

