/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.BindingType;
import com.azure.resourcemanager.appplatform.models.BuildpackBindingLaunchProperties;
import com.azure.resourcemanager.appplatform.models.BuildpackBindingProvisioningState;
import java.io.IOException;

public final class BuildpackBindingProperties
implements JsonSerializable<BuildpackBindingProperties> {
    private BindingType bindingType;
    private BuildpackBindingProvisioningState provisioningState;
    private BuildpackBindingLaunchProperties launchProperties;

    public BindingType bindingType() {
        return this.bindingType;
    }

    public BuildpackBindingProperties withBindingType(BindingType bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    public BuildpackBindingProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public BuildpackBindingLaunchProperties launchProperties() {
        return this.launchProperties;
    }

    public BuildpackBindingProperties withLaunchProperties(BuildpackBindingLaunchProperties launchProperties) {
        this.launchProperties = launchProperties;
        return this;
    }

    public void validate() {
        if (this.launchProperties() != null) {
            this.launchProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bindingType", this.bindingType == null ? null : this.bindingType.toString());
        jsonWriter.writeJsonField("launchProperties", (JsonSerializable)this.launchProperties);
        return jsonWriter.writeEndObject();
    }

    public static BuildpackBindingProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BuildpackBindingProperties)jsonReader.readObject(reader -> {
            BuildpackBindingProperties deserializedBuildpackBindingProperties = new BuildpackBindingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bindingType".equals(fieldName)) {
                    deserializedBuildpackBindingProperties.bindingType = BindingType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBuildpackBindingProperties.provisioningState = BuildpackBindingProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("launchProperties".equals(fieldName)) {
                    deserializedBuildpackBindingProperties.launchProperties = BuildpackBindingLaunchProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildpackBindingProperties;
        });
    }
}

