/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.CertificatesClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.CertificateInner;
import com.azure.resourcemanager.appservice.implementation.AppServiceCertificateImpl;
import com.azure.resourcemanager.appservice.models.AppServiceCertificate;
import com.azure.resourcemanager.appservice.models.AppServiceCertificates;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import reactor.core.publisher.Mono;

public class AppServiceCertificatesImpl
extends GroupableResourcesImpl<AppServiceCertificate, AppServiceCertificateImpl, CertificateInner, CertificatesClient, AppServiceManager>
implements AppServiceCertificates {
    public AppServiceCertificatesImpl(AppServiceManager manager) {
        super((Object)((WebSiteManagementClient)manager.serviceClient()).getCertificates(), (Manager)manager);
    }

    protected Mono<CertificateInner> getInnerAsync(String resourceGroupName, String name) {
        return ((CertificatesClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((CertificatesClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    public PagedIterable<AppServiceCertificate> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.wrapPageAsync(((CertificatesClient)this.inner()).listByResourceGroupAsync(resourceGroupName)));
    }

    public PagedFlux<AppServiceCertificate> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((CertificatesClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    protected AppServiceCertificateImpl wrapModel(String name) {
        return new AppServiceCertificateImpl(name, new CertificateInner(), (AppServiceManager)this.manager());
    }

    protected AppServiceCertificateImpl wrapModel(CertificateInner inner) {
        if (inner == null) {
            return null;
        }
        return new AppServiceCertificateImpl(inner.name(), inner, (AppServiceManager)this.manager());
    }

    public AppServiceCertificateImpl define(String name) {
        return this.wrapModel(name);
    }

    public PagedIterable<AppServiceCertificate> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<AppServiceCertificate> listAsync() {
        return this.wrapPageAsync(((CertificatesClient)this.inner()).listAsync());
    }
}

