/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.implementation.AppServiceBaseImpl;
import com.azure.resourcemanager.appservice.implementation.FunctionDeploymentSlotsImpl;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionAuthenticationPolicy;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlots;
import com.azure.resourcemanager.appservice.models.FunctionEnvelope;
import com.azure.resourcemanager.appservice.models.FunctionRuntimeStack;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.SkuName;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.policy.AuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.AuxiliaryAuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.resourcemanager.storage.models.StorageAccountKey;
import com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FunctionAppImpl
extends AppServiceBaseImpl<FunctionApp, FunctionAppImpl, FunctionApp.DefinitionStages.WithCreate, FunctionApp.Update>
implements FunctionApp,
FunctionApp.Definition,
FunctionApp.DefinitionStages.NewAppServicePlanWithGroup,
FunctionApp.DefinitionStages.ExistingLinuxPlanWithGroup,
FunctionApp.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private static final String SETTING_WEBSITE_CONTENTAZUREFILECONNECTIONSTRING = "WEBSITE_CONTENTAZUREFILECONNECTIONSTRING";
    private static final String SETTING_WEBSITE_CONTENTSHARE = "WEBSITE_CONTENTSHARE";
    private static final String SETTING_WEB_JOBS_STORAGE = "AzureWebJobsStorage";
    private static final String SETTING_WEB_JOBS_DASHBOARD = "AzureWebJobsDashboard";
    private Creatable<StorageAccount> storageAccountCreatable;
    private StorageAccount storageAccountToSet;
    private StorageAccount currentStorageAccount;
    private final FunctionAppKeyService functionAppKeyService;
    private FunctionService functionService;
    private FunctionDeploymentSlots deploymentSlots;
    private final String functionAppKeyServiceHost;
    private String functionServiceHost;

    FunctionAppImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, AppServiceManager manager) {
        super(name, innerObject, siteConfig, logConfig, manager);
        this.functionAppKeyServiceHost = manager.environment().getResourceManagerEndpoint();
        this.functionAppKeyService = (FunctionAppKeyService)RestProxy.create(FunctionAppKeyService.class, (HttpPipeline)manager.httpPipeline());
        if (!this.isInCreateMode()) {
            this.initializeFunctionService();
        }
    }

    private void initializeFunctionService() {
        if (this.functionService == null) {
            String baseUrl;
            UrlBuilder urlBuilder = UrlBuilder.parse((String)this.defaultHostname());
            if (urlBuilder.getScheme() == null) {
                urlBuilder.setScheme("https");
            }
            try {
                baseUrl = urlBuilder.toUrl().toString();
            }
            catch (MalformedURLException e) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
            }
            ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
            int count = ((AppServiceManager)this.manager()).httpPipeline().getPolicyCount();
            for (int i = 0; i < count; ++i) {
                HttpPipelinePolicy policy = ((AppServiceManager)this.manager()).httpPipeline().getPolicy(i);
                if (policy instanceof AuthenticationPolicy || policy instanceof ProviderRegistrationPolicy || policy instanceof AuxiliaryAuthenticationPolicy) continue;
                policies.add(policy);
            }
            policies.add(new FunctionAuthenticationPolicy(this));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(((AppServiceManager)this.manager()).httpPipeline().getHttpClient()).build();
            this.functionServiceHost = baseUrl;
            this.functionService = (FunctionService)RestProxy.create(FunctionService.class, (HttpPipeline)httpPipeline, (SerializerAdapter)SerializerFactory.createDefaultManagementSerializerAdapter());
        }
    }

    @Override
    public void setInner(SiteInner innerObject) {
        super.setInner(innerObject);
    }

    @Override
    public FunctionDeploymentSlots deploymentSlots() {
        if (this.deploymentSlots == null) {
            this.deploymentSlots = new FunctionDeploymentSlotsImpl(this);
        }
        return this.deploymentSlots;
    }

    @Override
    public FunctionAppImpl withNewConsumptionPlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withNewConsumptionPlan(String appServicePlanName) {
        return this.withNewAppServicePlan(appServicePlanName, OperatingSystem.WINDOWS, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withRuntime(String runtime) {
        return (FunctionAppImpl)this.withAppSetting("FUNCTIONS_WORKER_RUNTIME", runtime);
    }

    @Override
    public FunctionAppImpl withRuntimeVersion(String version) {
        return (FunctionAppImpl)this.withAppSetting("FUNCTIONS_EXTENSION_VERSION", version.startsWith("~") ? version : "~" + version);
    }

    @Override
    public FunctionAppImpl withLatestRuntimeVersion() {
        return this.withRuntimeVersion("latest");
    }

    @Override
    Mono<Indexable> submitAppSettings() {
        if (this.storageAccountCreatable != null && this.taskResult(this.storageAccountCreatable.key()) != null) {
            this.storageAccountToSet = (StorageAccount)this.taskResult(this.storageAccountCreatable.key());
        }
        if (this.storageAccountToSet == null) {
            return super.submitAppSettings();
        }
        return Flux.concat((Publisher)this.storageAccountToSet.getKeysAsync().map(storageAccountKeys -> (StorageAccountKey)storageAccountKeys.get(0)).zipWith(((AppServiceManager)this.manager()).appServicePlans().getByIdAsync(this.appServicePlanId()), (storageAccountKey, appServicePlan) -> {
            String connectionString = ResourceManagerUtils.getStorageConnectionString((String)this.storageAccountToSet.name(), (String)storageAccountKey.value(), (AzureEnvironment)((AppServiceManager)this.manager()).environment());
            this.addAppSettingIfNotModified(SETTING_WEB_JOBS_STORAGE, connectionString);
            this.addAppSettingIfNotModified(SETTING_WEB_JOBS_DASHBOARD, connectionString);
            if (OperatingSystem.WINDOWS.equals((Object)this.operatingSystem()) && (appServicePlan == null || FunctionAppImpl.isConsumptionOrPremiumAppServicePlan(appServicePlan.pricingTier()))) {
                this.addAppSettingIfNotModified(SETTING_WEBSITE_CONTENTAZUREFILECONNECTIONSTRING, connectionString);
                this.addAppSettingIfNotModified(SETTING_WEBSITE_CONTENTSHARE, ((AppServiceManager)this.manager()).resourceManager().internalContext().randomResourceName(this.name(), 32));
            }
            return FunctionAppImpl.super.submitAppSettings();
        })).last().then(Mono.fromCallable(() -> {
            this.currentStorageAccount = this.storageAccountToSet;
            this.storageAccountToSet = null;
            this.storageAccountCreatable = null;
            return this;
        }));
    }

    @Override
    public OperatingSystem operatingSystem() {
        return ((SiteInner)((Object)this.innerModel())).reserved() == null || ((SiteInner)((Object)this.innerModel())).reserved() == false ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
    }

    private void addAppSettingIfNotModified(String key, String value) {
        if (!this.appSettingModified(key)) {
            this.withAppSetting(key, value);
        }
    }

    private boolean appSettingModified(String key) {
        return this.appSettingsToAdd != null && this.appSettingsToAdd.containsKey(key) || this.appSettingsToRemove != null && this.appSettingsToRemove.contains(key);
    }

    private static boolean isConsumptionOrPremiumAppServicePlan(PricingTier pricingTier) {
        if (pricingTier == null || pricingTier.toSkuDescription() == null) {
            return true;
        }
        SkuDescription description = pricingTier.toSkuDescription();
        return SkuName.DYNAMIC.toString().equalsIgnoreCase(description.tier()) || SkuName.ELASTIC_PREMIUM.toString().equalsIgnoreCase(description.tier());
    }

    @Override
    FunctionAppImpl withNewAppServicePlan(OperatingSystem operatingSystem, PricingTier pricingTier) {
        return ((FunctionAppImpl)super.withNewAppServicePlan(operatingSystem, pricingTier)).autoSetAlwaysOn(pricingTier);
    }

    @Override
    FunctionAppImpl withNewAppServicePlan(String appServicePlan, OperatingSystem operatingSystem, PricingTier pricingTier) {
        return ((FunctionAppImpl)super.withNewAppServicePlan(appServicePlan, operatingSystem, pricingTier)).autoSetAlwaysOn(pricingTier);
    }

    @Override
    public FunctionAppImpl withExistingAppServicePlan(AppServicePlan appServicePlan) {
        super.withExistingAppServicePlan(appServicePlan);
        return this.autoSetAlwaysOn(appServicePlan.pricingTier());
    }

    private FunctionAppImpl autoSetAlwaysOn(PricingTier pricingTier) {
        SkuDescription description = pricingTier.toSkuDescription();
        if (description.tier().equalsIgnoreCase(SkuName.BASIC.toString()) || description.tier().equalsIgnoreCase(SkuName.STANDARD.toString()) || description.tier().equalsIgnoreCase(SkuName.PREMIUM.toString()) || description.tier().equalsIgnoreCase(SkuName.PREMIUM_V2.toString())) {
            return (FunctionAppImpl)this.withWebAppAlwaysOn(true);
        }
        return (FunctionAppImpl)this.withWebAppAlwaysOn(false);
    }

    @Override
    public FunctionAppImpl withNewStorageAccount(String name, StorageAccountSkuType sku) {
        StorageAccount.DefinitionStages.WithGroup storageDefine = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)((AppServiceManager)this.manager()).storageManager().storageAccounts().define(name)).withRegion(this.regionName());
        this.storageAccountCreatable = this.creatableGroup != null && this.isInCreateMode() ? ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withNewResourceGroup(this.creatableGroup)).withGeneralPurposeAccountKind().withSku(sku) : ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withExistingResourceGroup(this.resourceGroupName())).withGeneralPurposeAccountKind().withSku(sku);
        this.addDependency(this.storageAccountCreatable);
        return this;
    }

    @Override
    public FunctionAppImpl withNewStorageAccount(Creatable<StorageAccount> storageAccount) {
        this.storageAccountCreatable = storageAccount;
        this.addDependency(this.storageAccountCreatable);
        return this;
    }

    @Override
    public FunctionAppImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.storageAccountToSet = storageAccount;
        return this;
    }

    @Override
    public FunctionAppImpl withDailyUsageQuota(int quota) {
        ((SiteInner)((Object)this.innerModel())).withDailyMemoryTimeQuota(quota);
        return this;
    }

    @Override
    public FunctionAppImpl withoutDailyUsageQuota() {
        return this.withDailyUsageQuota(0);
    }

    @Override
    public FunctionAppImpl withNewLinuxConsumptionPlan() {
        return this.withNewAppServicePlan(OperatingSystem.LINUX, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withNewLinuxConsumptionPlan(String appServicePlanName) {
        return this.withNewAppServicePlan(appServicePlanName, OperatingSystem.LINUX, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withNewLinuxAppServicePlan(PricingTier pricingTier) {
        return (FunctionAppImpl)super.withNewAppServicePlan(OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public FunctionAppImpl withNewLinuxAppServicePlan(String appServicePlanName, PricingTier pricingTier) {
        return (FunctionAppImpl)super.withNewAppServicePlan(appServicePlanName, OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public FunctionAppImpl withNewLinuxAppServicePlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        super.withNewAppServicePlan(appServicePlanCreatable);
        if (appServicePlanCreatable instanceof AppServicePlan) {
            this.autoSetAlwaysOn(((AppServicePlan)appServicePlanCreatable).pricingTier());
        }
        return this;
    }

    @Override
    public FunctionAppImpl withExistingLinuxAppServicePlan(AppServicePlan appServicePlan) {
        return ((FunctionAppImpl)super.withExistingAppServicePlan(appServicePlan)).autoSetAlwaysOn(appServicePlan.pricingTier());
    }

    @Override
    public FunctionAppImpl withBuiltInImage(FunctionRuntimeStack runtimeStack) {
        this.ensureLinuxPlan();
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.withRuntime(runtimeStack.runtime());
        this.withRuntimeVersion(runtimeStack.version());
        this.siteConfig.withLinuxFxVersion(runtimeStack.getLinuxFxVersion());
        return this;
    }

    @Override
    public FunctionAppImpl withPublicDockerHubImage(String imageAndTag) {
        this.ensureLinuxPlan();
        return (FunctionAppImpl)super.withPublicDockerHubImage(imageAndTag);
    }

    @Override
    public FunctionAppImpl withPrivateDockerHubImage(String imageAndTag) {
        this.ensureLinuxPlan();
        return (FunctionAppImpl)super.withPublicDockerHubImage(imageAndTag);
    }

    @Override
    public FunctionAppImpl withPrivateRegistryImage(String imageAndTag, String serverUrl) {
        this.ensureLinuxPlan();
        return (FunctionAppImpl)super.withPrivateRegistryImage(imageAndTag, serverUrl);
    }

    @Override
    protected void cleanUpContainerSettings() {
        if (this.siteConfig != null && this.siteConfig.linuxFxVersion() != null) {
            this.siteConfig.withLinuxFxVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.windowsFxVersion() != null) {
            this.siteConfig.withWindowsFxVersion(null);
        }
        this.withoutAppSetting("DOCKER_CUSTOM_IMAGE_NAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_URL");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_USERNAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_PASSWORD");
    }

    @Override
    protected OperatingSystem appServicePlanOperatingSystem(AppServicePlan appServicePlan) {
        return ((AppServicePlanInner)((Object)appServicePlan.innerModel())).reserved() == null || ((AppServicePlanInner)((Object)appServicePlan.innerModel())).reserved() == false ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
    }

    @Override
    public StorageAccount storageAccount() {
        return this.currentStorageAccount;
    }

    @Override
    public String getMasterKey() {
        return (String)this.getMasterKeyAsync().block();
    }

    @Override
    public Mono<String> getMasterKeyAsync() {
        Context context1 = ((AppServiceManager)this.manager()).serviceClient() instanceof WebSiteManagementClientImpl ? ((WebSiteManagementClientImpl)((AppServiceManager)this.manager()).serviceClient()).getContext() : Context.NONE;
        return FluxUtil.withContext(context -> this.functionAppKeyService.listKeys(this.functionAppKeyServiceHost, this.resourceGroupName(), this.name(), ((AppServiceManager)this.manager()).subscriptionId(), "2019-08-01")).map(ListKeysResult::getMasterKey).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)context1)));
    }

    @Override
    public PagedIterable<FunctionEnvelope> listFunctions() {
        return ((AppServiceManager)this.manager()).functionApps().listFunctions(this.resourceGroupName(), this.name());
    }

    @Override
    public Map<String, String> listFunctionKeys(String functionName) {
        return (Map)this.listFunctionKeysAsync(functionName).block();
    }

    @Override
    public Mono<Map<String, String>> listFunctionKeysAsync(String functionName) {
        return this.functionService.listFunctionKeys(this.functionServiceHost, functionName).map(result -> {
            HashMap<String, String> keys = new HashMap<String, String>();
            if (((FunctionKeyListResult)result).keys != null) {
                for (NameValuePair pair : ((FunctionKeyListResult)result).keys) {
                    keys.put(pair.name(), pair.value());
                }
            }
            return keys;
        });
    }

    @Override
    public NameValuePair addFunctionKey(String functionName, String keyName, String keyValue) {
        return (NameValuePair)this.addFunctionKeyAsync(functionName, keyName, keyValue).block();
    }

    @Override
    public Mono<NameValuePair> addFunctionKeyAsync(String functionName, String keyName, String keyValue) {
        if (keyValue != null) {
            return this.functionService.addFunctionKey(this.functionServiceHost, functionName, keyName, new NameValuePair().withName(keyName).withValue(keyValue));
        }
        return this.functionService.generateFunctionKey(this.functionServiceHost, functionName, keyName);
    }

    @Override
    public void removeFunctionKey(String functionName, String keyName) {
        this.removeFunctionKeyAsync(functionName, keyName).block();
    }

    @Override
    public Mono<Void> removeFunctionKeyAsync(String functionName, String keyName) {
        return this.functionService.deleteFunctionKey(this.functionServiceHost, functionName, keyName);
    }

    @Override
    public void triggerFunction(String functionName, Object payload) {
        this.triggerFunctionAsync(functionName, payload).block();
    }

    @Override
    public Mono<Void> triggerFunctionAsync(String functionName, Object payload) {
        return this.functionService.triggerFunction(this.functionServiceHost, functionName, payload);
    }

    @Override
    public void syncTriggers() {
        this.syncTriggersAsync().block();
    }

    @Override
    public Mono<Void> syncTriggersAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().syncFunctionTriggersAsync(this.resourceGroupName(), this.name()).onErrorResume(throwable -> {
            if (throwable instanceof ManagementException && ((ManagementException)throwable).getResponse().getStatusCode() == 200) {
                return Mono.empty();
            }
            return Mono.error((Throwable)throwable);
        });
    }

    @Override
    public Flux<String> streamApplicationLogsAsync() {
        return this.functionService.ping(this.functionServiceHost).then(this.functionService.getHostStatus(this.functionServiceHost)).thenMany((Publisher)FunctionAppImpl.super.streamApplicationLogsAsync());
    }

    @Override
    public Flux<String> streamHttpLogsAsync() {
        return this.functionService.ping(this.functionServiceHost).then(this.functionService.getHostStatus(this.functionServiceHost)).thenMany((Publisher)FunctionAppImpl.super.streamHttpLogsAsync());
    }

    @Override
    public Flux<String> streamTraceLogsAsync() {
        return this.functionService.ping(this.functionServiceHost).then(this.functionService.getHostStatus(this.functionServiceHost)).thenMany((Publisher)FunctionAppImpl.super.streamTraceLogsAsync());
    }

    @Override
    public Flux<String> streamDeploymentLogsAsync() {
        return this.functionService.ping(this.functionServiceHost).then(this.functionService.getHostStatus(this.functionServiceHost)).thenMany((Publisher)FunctionAppImpl.super.streamDeploymentLogsAsync());
    }

    @Override
    public Flux<String> streamAllLogsAsync() {
        return this.functionService.ping(this.functionServiceHost).then(this.functionService.getHostStatus(this.functionServiceHost)).thenMany((Publisher)FunctionAppImpl.super.streamAllLogsAsync());
    }

    @Override
    public Mono<Void> zipDeployAsync(File zipFile) {
        try {
            return this.kuduClient.zipDeployAsync(zipFile);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).block();
    }

    @Override
    public Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        return this.kuduClient.zipDeployAsync(zipFile, length);
    }

    @Override
    public void zipDeploy(InputStream zipFile, long length) {
        this.zipDeployAsync(zipFile, length).block();
    }

    public Mono<FunctionApp> createAsync() {
        if (this.isInCreateMode()) {
            if (((SiteInner)((Object)this.innerModel())).serverFarmId() == null) {
                this.withNewConsumptionPlan();
            }
            if (this.currentStorageAccount == null && this.storageAccountToSet == null && this.storageAccountCreatable == null) {
                this.withNewStorageAccount(((AppServiceManager)this.manager()).resourceManager().internalContext().randomResourceName(this.name(), 20), StorageAccountSkuType.STANDARD_GRS);
            }
        }
        return super.createAsync();
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        if (!isGroupFaulted) {
            this.initializeFunctionService();
        }
        return super.afterPostRunAsync(isGroupFaulted);
    }

    private static class FunctionKeyListResult {
        @JsonProperty(value="keys")
        private List<NameValuePair> keys;

        private FunctionKeyListResult() {
        }
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FunctionService")
    private static interface FunctionService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json; charset=utf-8"})
        @Get(value="admin/functions/{name}/keys")
        public Mono<FunctionKeyListResult> listFunctionKeys(@HostParam(value="$host") String var1, @PathParam(value="name") String var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json; charset=utf-8"})
        @Put(value="admin/functions/{name}/keys/{keyName}")
        public Mono<NameValuePair> addFunctionKey(@HostParam(value="$host") String var1, @PathParam(value="name") String var2, @PathParam(value="keyName") String var3, @BodyParam(value="application/json") NameValuePair var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json; charset=utf-8"})
        @Post(value="admin/functions/{name}/keys/{keyName}")
        public Mono<NameValuePair> generateFunctionKey(@HostParam(value="$host") String var1, @PathParam(value="name") String var2, @PathParam(value="keyName") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Delete(value="admin/functions/{name}/keys/{keyName}")
        public Mono<Void> deleteFunctionKey(@HostParam(value="$host") String var1, @PathParam(value="name") String var2, @PathParam(value="keyName") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Post(value="admin/host/ping")
        public Mono<Void> ping(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Get(value="admin/host/status")
        public Mono<Void> getHostStatus(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Post(value="admin/functions/{name}")
        public Mono<Void> triggerFunction(@HostParam(value="$host") String var1, @PathParam(value="name") String var2, @BodyParam(value="application/json") Object var3);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FunctionKeyService")
    private static interface FunctionAppKeyService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json; charset=utf-8"})
        @Post(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listkeys")
        public Mono<ListKeysResult> listKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5);
    }

    private static class ListKeysResult {
        @JsonProperty(value="masterKey")
        private String masterKey;
        @JsonProperty(value="functionKeys")
        private Map<String, String> functionKeys;
        @JsonProperty(value="systemKeys")
        private Map<String, String> systemKeys;

        private ListKeysResult() {
        }

        public String getMasterKey() {
            return this.masterKey;
        }
    }
}

