/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.KuduAuthenticationPolicy;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.policy.AuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.AuxiliaryAuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Locale;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

class KuduClient {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final String host;
    private final KuduService service;

    KuduClient(WebAppBase webAppBase) {
        if (webAppBase.defaultHostname() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot initialize kudu client before web app is created"));
        }
        String host = webAppBase.defaultHostname().toLowerCase(Locale.ROOT).replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = parts[0] + ".scm." + parts[1];
        this.host = "https://" + host;
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        int count = ((AppServiceManager)((Object)webAppBase.manager())).httpPipeline().getPolicyCount();
        for (int i = 0; i < count; ++i) {
            HttpPipelinePolicy policy = ((AppServiceManager)((Object)webAppBase.manager())).httpPipeline().getPolicy(i);
            if (policy instanceof AuthenticationPolicy || policy instanceof ProviderRegistrationPolicy || policy instanceof AuxiliaryAuthenticationPolicy) continue;
            policies.add(policy);
        }
        policies.add(new KuduAuthenticationPolicy(webAppBase));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(((AppServiceManager)((Object)webAppBase.manager())).httpPipeline().getHttpClient()).build();
        this.service = (KuduService)RestProxy.create(KuduService.class, (HttpPipeline)httpPipeline, (SerializerAdapter)SerializerFactory.createDefaultManagementSerializerAdapter());
    }

    Flux<String> streamApplicationLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamApplicationLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamHttpLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamHttpLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamTraceLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamTraceLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamDeploymentLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamDeploymentLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamAllLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamAllLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    static Flux<String> streamFromFluxBytes(Flux<ByteBuffer> source) {
        int newLine = 10;
        int newLineR = 13;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        return source.concatMap(byteBuffer -> {
            int index = KuduClient.findByte(byteBuffer, (byte)10);
            if (index == -1) {
                try {
                    stream.write(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer));
                    return Flux.empty();
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            ArrayList<String> lines = new ArrayList<String>();
            while ((index = KuduClient.findByte(byteBuffer, (byte)10)) != -1) {
                byte[] byteArray = new byte[index + 1];
                byteBuffer.get(byteArray);
                try {
                    stream.write(byteArray);
                    String line = new String(stream.toByteArray(), StandardCharsets.UTF_8);
                    if (line.isEmpty() || line.charAt(line.length() - 1) != '\n') continue;
                    if (!(line = line.substring(0, line.length() - 1)).isEmpty() && line.charAt(line.length() - 1) == '\r') {
                        line = line.substring(0, line.length() - 1);
                    }
                    lines.add(line);
                    stream.reset();
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            if (byteBuffer.hasRemaining()) {
                try {
                    stream.write(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer));
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            if (lines.isEmpty()) {
                return Flux.empty();
            }
            return Flux.fromIterable(lines);
        });
    }

    private static int findByte(ByteBuffer byteBuffer, byte b) {
        int position = byteBuffer.position();
        int index = -1;
        for (int i = 0; i < byteBuffer.remaining(); ++i) {
            if (byteBuffer.get(position + i) != b) continue;
            index = i;
            break;
        }
        return index;
    }

    Mono<Void> warDeployAsync(InputStream warFile, long length, String appName) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)warFile);
        return this.withRetry(this.service.warDeploy(this.host, (Flux<ByteBuffer>)flux, length, appName));
    }

    Mono<Void> warDeployAsync(File warFile, String appName) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(warFile.toPath(), StandardOpenOption.READ);
        return this.withRetry((Mono<Void>)this.service.warDeploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), appName).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        }));
    }

    Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)zipFile);
        return this.withRetry(this.service.zipDeploy(this.host, (Flux<ByteBuffer>)flux, length));
    }

    Mono<Void> zipDeployAsync(File zipFile) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(zipFile.toPath(), StandardOpenOption.READ);
        return this.withRetry((Mono<Void>)this.service.zipDeploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size()).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        }));
    }

    private Mono<Void> withRetry(Mono<Void> observable) {
        return observable.retryWhen(Retry.withThrowable(flux -> flux.zipWith((Publisher)Flux.range((int)1, (int)6), (throwable, integer) -> {
            if (throwable instanceof ManagementException && ((ManagementException)throwable).getResponse().getStatusCode() == 502 || throwable instanceof JsonParseException) {
                return integer;
            }
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)throwable));
        }).flatMap(i -> Mono.delay((Duration)Duration.ofSeconds((long)i.intValue() * 10L)))));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KuduService")
    private static interface KuduService {
        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamApplicationLogs", "x-ms-body-logging: false"})
        @Get(value="api/logstream/application")
        public Mono<StreamResponse> streamApplicationLogs(@HostParam(value="$host") String var1);

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamHttpLogs", "x-ms-body-logging: false"})
        @Get(value="api/logstream/http")
        public Mono<StreamResponse> streamHttpLogs(@HostParam(value="$host") String var1);

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamTraceLogs", "x-ms-body-logging: false"})
        @Get(value="api/logstream/kudu/trace")
        public Mono<StreamResponse> streamTraceLogs(@HostParam(value="$host") String var1);

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamDeploymentLogs", "x-ms-body-logging: false"})
        @Get(value="api/logstream/kudu/deployment")
        public Mono<StreamResponse> streamDeploymentLogs(@HostParam(value="$host") String var1);

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamAllLogs", "x-ms-body-logging: false"})
        @Get(value="api/logstream")
        public Mono<StreamResponse> streamAllLogs(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/octet-stream", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps warDeploy", "x-ms-body-logging: false"})
        @Post(value="api/wardeploy")
        public Mono<Void> warDeploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @QueryParam(value="name") String var5);

        @Headers(value={"Content-Type: application/octet-stream", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps zipDeploy", "x-ms-body-logging: false"})
        @Post(value="api/zipdeploy")
        public Mono<Void> zipDeploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3);
    }
}

