/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.StaticSitesClient;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteBuildArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteCustomDomainOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteFunctionOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserInvitationResponseResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCustomDomainOverviewCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteFunctionOverviewCollection;
import com.azure.resourcemanager.appservice.models.StaticSitePatchResource;
import com.azure.resourcemanager.appservice.models.StaticSiteResetPropertiesArmResource;
import com.azure.resourcemanager.appservice.models.StaticSiteUserCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteUserInvitationRequestResource;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public final class StaticSitesClientImpl
implements InnerSupportsGet<StaticSiteArmResourceInner>,
InnerSupportsListing<StaticSiteArmResourceInner>,
StaticSitesClient {
    private final ClientLogger logger = new ClientLogger(StaticSitesClientImpl.class);
    private final StaticSitesService service;
    private final WebSiteManagementClientImpl client;

    StaticSitesClientImpl(WebSiteManagementClientImpl client) {
        this.service = (StaticSitesService)RestProxy.create(StaticSitesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteArmResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteArmResourceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteArmResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.getStaticSitesByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteArmResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.getStaticSitesByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    public Mono<Response<StaticSiteArmResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StaticSiteArmResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<StaticSiteArmResourceInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteArmResourceInner getByResourceGroup(String resourceGroupName, String name) {
        return (StaticSiteArmResourceInner)((Object)this.getByResourceGroupAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StaticSiteArmResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<StaticSiteArmResourceInner>> createOrUpdateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StaticSiteArmResourceInner>> createOrUpdateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, context);
    }

    @Override
    public Mono<StaticSiteArmResourceInner> createOrUpdateStaticSiteAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        return this.createOrUpdateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteArmResourceInner createOrUpdateStaticSite(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        return (StaticSiteArmResourceInner)((Object)this.createOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).block());
    }

    @Override
    public Response<StaticSiteArmResourceInner> createOrUpdateStaticSiteWithResponse(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        return (Response)this.createOrUpdateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteStaticSiteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteStaticSiteWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<Void> deleteStaticSiteAsync(String resourceGroupName, String name) {
        return this.deleteStaticSiteWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteStaticSite(String resourceGroupName, String name) {
        this.deleteStaticSiteAsync(resourceGroupName, name).block();
    }

    @Override
    public Response<Void> deleteStaticSiteWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.deleteStaticSiteWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<StaticSiteArmResourceInner>> updateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        return FluxUtil.withContext(context -> this.service.updateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StaticSiteArmResourceInner>> updateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        context = this.client.mergeContext(context);
        return this.service.updateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, context);
    }

    @Override
    public Mono<StaticSiteArmResourceInner> updateStaticSiteAsync(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope) {
        return this.updateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteArmResourceInner updateStaticSite(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope) {
        return (StaticSiteArmResourceInner)((Object)this.updateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).block());
    }

    @Override
    public Response<StaticSiteArmResourceInner> updateStaticSiteWithResponse(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope, Context context) {
        return (Response)this.updateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersSinglePageAsync(String resourceGroupName, String name, String authprovider) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteUsers(this.client.getEndpoint(), resourceGroupName, name, authprovider, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersSinglePageAsync(String resourceGroupName, String name, String authprovider, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteUsers(this.client.getEndpoint(), resourceGroupName, name, authprovider, this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteUserArmResourceInner> listStaticSiteUsersAsync(String resourceGroupName, String name, String authprovider) {
        return new PagedFlux(() -> this.listStaticSiteUsersSinglePageAsync(resourceGroupName, name, authprovider), nextLink -> this.listStaticSiteUsersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteUserArmResourceInner> listStaticSiteUsersAsync(String resourceGroupName, String name, String authprovider, Context context) {
        return new PagedFlux(() -> this.listStaticSiteUsersSinglePageAsync(resourceGroupName, name, authprovider, context), nextLink -> this.listStaticSiteUsersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(String resourceGroupName, String name, String authprovider) {
        return new PagedIterable(this.listStaticSiteUsersAsync(resourceGroupName, name, authprovider));
    }

    @Override
    public PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(String resourceGroupName, String name, String authprovider, Context context) {
        return new PagedIterable(this.listStaticSiteUsersAsync(resourceGroupName, name, authprovider, context));
    }

    @Override
    public Mono<Response<Void>> deleteStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<Void> deleteStaticSiteUserAsync(String resourceGroupName, String name, String authprovider, String userid) {
        return this.deleteStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteStaticSiteUser(String resourceGroupName, String name, String authprovider, String userid) {
        this.deleteStaticSiteUserAsync(resourceGroupName, name, authprovider, userid).block();
    }

    @Override
    public Response<Void> deleteStaticSiteUserWithResponse(String resourceGroupName, String name, String authprovider, String userid, Context context) {
        return (Response)this.deleteStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid, context).block();
    }

    @Override
    public Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserEnvelope is required and cannot be null."));
        }
        staticSiteUserEnvelope.validate();
        return FluxUtil.withContext(context -> this.service.updateStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserEnvelope, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserEnvelope is required and cannot be null."));
        }
        staticSiteUserEnvelope.validate();
        context = this.client.mergeContext(context);
        return this.service.updateStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserEnvelope, context);
    }

    @Override
    public Mono<StaticSiteUserArmResourceInner> updateStaticSiteUserAsync(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        return this.updateStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteUserArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteUserArmResourceInner updateStaticSiteUser(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        return (StaticSiteUserArmResourceInner)((Object)this.updateStaticSiteUserAsync(resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope).block());
    }

    @Override
    public Response<StaticSiteUserArmResourceInner> updateStaticSiteUserWithResponse(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope, Context context) {
        return (Response)this.updateStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getStaticSiteBuilds(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getStaticSiteBuilds(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteBuildArmResourceInner> getStaticSiteBuildsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.getStaticSiteBuildsSinglePageAsync(resourceGroupName, name), nextLink -> this.getStaticSiteBuildsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteBuildArmResourceInner> getStaticSiteBuildsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.getStaticSiteBuildsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.getStaticSiteBuildsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(String resourceGroupName, String name) {
        return new PagedIterable(this.getStaticSiteBuildsAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.getStaticSiteBuildsAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String prId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String prId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<StaticSiteBuildArmResourceInner> getStaticSiteBuildAsync(String resourceGroupName, String name, String prId) {
        return this.getStaticSiteBuildWithResponseAsync(resourceGroupName, name, prId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteBuildArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteBuildArmResourceInner getStaticSiteBuild(String resourceGroupName, String name, String prId) {
        return (StaticSiteBuildArmResourceInner)((Object)this.getStaticSiteBuildAsync(resourceGroupName, name, prId).block());
    }

    @Override
    public Response<StaticSiteBuildArmResourceInner> getStaticSiteBuildWithResponse(String resourceGroupName, String name, String prId, Context context) {
        return (Response)this.getStaticSiteBuildWithResponseAsync(resourceGroupName, name, prId, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String prId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String prId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<Void> deleteStaticSiteBuildAsync(String resourceGroupName, String name, String prId) {
        return this.deleteStaticSiteBuildWithResponseAsync(resourceGroupName, name, prId).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteStaticSiteBuild(String resourceGroupName, String name, String prId) {
        this.deleteStaticSiteBuildAsync(resourceGroupName, name, prId).block();
    }

    @Override
    public Response<Void> deleteStaticSiteBuildWithResponse(String resourceGroupName, String name, String prId, Context context) {
        return (Response)this.deleteStaticSiteBuildWithResponseAsync(resourceGroupName, name, prId, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String prId, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String prId, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, context);
    }

    @Override
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsAsync(String resourceGroupName, String name, String prId, StringDictionaryInner appSettings) {
        return this.createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, prId, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner createOrUpdateStaticSiteBuildFunctionAppSettings(String resourceGroupName, String name, String prId, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.createOrUpdateStaticSiteBuildFunctionAppSettingsAsync(resourceGroupName, name, prId, appSettings).block());
    }

    @Override
    public Response<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponse(String resourceGroupName, String name, String prId, StringDictionaryInner appSettings, Context context) {
        return (Response)this.createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, prId, appSettings, context).block();
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsSinglePageAsync(String resourceGroupName, String name, String prId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteBuildFunctions(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsSinglePageAsync(String resourceGroupName, String name, String prId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteBuildFunctions(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctionsAsync(String resourceGroupName, String name, String prId) {
        return new PagedFlux(() -> this.listStaticSiteBuildFunctionsSinglePageAsync(resourceGroupName, name, prId), nextLink -> this.listStaticSiteBuildFunctionsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctionsAsync(String resourceGroupName, String name, String prId, Context context) {
        return new PagedFlux(() -> this.listStaticSiteBuildFunctionsSinglePageAsync(resourceGroupName, name, prId, context), nextLink -> this.listStaticSiteBuildFunctionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctions(String resourceGroupName, String name, String prId) {
        return new PagedIterable(this.listStaticSiteBuildFunctionsAsync(resourceGroupName, name, prId));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctions(String resourceGroupName, String name, String prId, Context context) {
        return new PagedIterable(this.listStaticSiteBuildFunctionsAsync(resourceGroupName, name, prId, context));
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String prId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String prId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (prId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter prId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, prId, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsAsync(String resourceGroupName, String name, String prId) {
        return this.listStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, prId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteBuildFunctionAppSettings(String resourceGroupName, String name, String prId) {
        return (StringDictionaryInner)((Object)this.listStaticSiteBuildFunctionAppSettingsAsync(resourceGroupName, name, prId).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsWithResponse(String resourceGroupName, String name, String prId, Context context) {
        return (Response)this.listStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, prId, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, context);
    }

    @Override
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return this.createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner createOrUpdateStaticSiteFunctionAppSettings(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.createOrUpdateStaticSiteFunctionAppSettingsAsync(resourceGroupName, name, appSettings).block());
    }

    @Override
    public Response<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsWithResponse(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        return (Response)this.createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, appSettings, context).block();
    }

    @Override
    public Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLinkWithResponseAsync(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserRolesInvitationEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserRolesInvitationEnvelope is required and cannot be null."));
        }
        staticSiteUserRolesInvitationEnvelope.validate();
        return FluxUtil.withContext(context -> this.service.createUserRolesInvitationLink(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserRolesInvitationEnvelope, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLinkWithResponseAsync(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserRolesInvitationEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserRolesInvitationEnvelope is required and cannot be null."));
        }
        staticSiteUserRolesInvitationEnvelope.validate();
        context = this.client.mergeContext(context);
        return this.service.createUserRolesInvitationLink(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserRolesInvitationEnvelope, context);
    }

    @Override
    public Mono<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkAsync(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        return this.createUserRolesInvitationLinkWithResponseAsync(resourceGroupName, name, staticSiteUserRolesInvitationEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteUserInvitationResponseResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteUserInvitationResponseResourceInner createUserRolesInvitationLink(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        return (StaticSiteUserInvitationResponseResourceInner)((Object)this.createUserRolesInvitationLinkAsync(resourceGroupName, name, staticSiteUserRolesInvitationEnvelope).block());
    }

    @Override
    public Response<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkWithResponse(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope, Context context) {
        return (Response)this.createUserRolesInvitationLinkWithResponseAsync(resourceGroupName, name, staticSiteUserRolesInvitationEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteCustomDomains(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteCustomDomains(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomainsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listStaticSiteCustomDomainsSinglePageAsync(resourceGroupName, name), nextLink -> this.listStaticSiteCustomDomainsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomainsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listStaticSiteCustomDomainsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listStaticSiteCustomDomainsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomains(String resourceGroupName, String name) {
        return new PagedIterable(this.listStaticSiteCustomDomainsAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomains(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listStaticSiteCustomDomainsAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> createOrUpdateStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> createOrUpdateStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<StaticSiteCustomDomainOverviewArmResourceInner> createOrUpdateStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName) {
        return this.createOrUpdateStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteCustomDomainOverviewArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteCustomDomainOverviewArmResourceInner createOrUpdateStaticSiteCustomDomain(String resourceGroupName, String name, String domainName) {
        return (StaticSiteCustomDomainOverviewArmResourceInner)((Object)this.createOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).block());
    }

    @Override
    public Response<StaticSiteCustomDomainOverviewArmResourceInner> createOrUpdateStaticSiteCustomDomainWithResponse(String resourceGroupName, String name, String domainName, Context context) {
        return (Response)this.createOrUpdateStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<Void> deleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName) {
        return this.deleteStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName) {
        this.deleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).block();
    }

    @Override
    public Response<Void> deleteStaticSiteCustomDomainWithResponse(String resourceGroupName, String name, String domainName, Context context) {
        return (Response)this.deleteStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, context).block();
    }

    @Override
    public Mono<Response<Void>> validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(String resourceGroupName, String name, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.validateCustomDomainCanBeAddedToStaticSite(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(String resourceGroupName, String name, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.validateCustomDomainCanBeAddedToStaticSite(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<Void> validateCustomDomainCanBeAddedToStaticSiteAsync(String resourceGroupName, String name, String domainName) {
        return this.validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(resourceGroupName, name, domainName).flatMap(res -> Mono.empty());
    }

    @Override
    public void validateCustomDomainCanBeAddedToStaticSite(String resourceGroupName, String name, String domainName) {
        this.validateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName).block();
    }

    @Override
    public Response<Void> validateCustomDomainCanBeAddedToStaticSiteWithResponse(String resourceGroupName, String name, String domainName, Context context) {
        return (Response)this.validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(resourceGroupName, name, domainName, context).block();
    }

    @Override
    public Mono<Response<Void>> detachStaticSiteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.detachStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> detachStaticSiteWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.detachStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<Void> detachStaticSiteAsync(String resourceGroupName, String name) {
        return this.detachStaticSiteWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    public void detachStaticSite(String resourceGroupName, String name) {
        this.detachStaticSiteAsync(resourceGroupName, name).block();
    }

    @Override
    public Response<Void> detachStaticSiteWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.detachStaticSiteWithResponseAsync(resourceGroupName, name, context).block();
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctionsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listStaticSiteFunctionsSinglePageAsync(resourceGroupName, name), nextLink -> this.listStaticSiteFunctionsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctionsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listStaticSiteFunctionsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listStaticSiteFunctionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(String resourceGroupName, String name) {
        return new PagedIterable(this.listStaticSiteFunctionsAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listStaticSiteFunctionsAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteFunctionAppSettingsAsync(String resourceGroupName, String name) {
        return this.listStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteFunctionAppSettings(String resourceGroupName, String name) {
        return (StringDictionaryInner)((Object)this.listStaticSiteFunctionAppSettingsAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteFunctionAppSettingsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteSecretsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteSecretsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteSecretsAsync(String resourceGroupName, String name) {
        return this.listStaticSiteSecretsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteSecrets(String resourceGroupName, String name) {
        return (StringDictionaryInner)((Object)this.listStaticSiteSecretsAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteSecretsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listStaticSiteSecretsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<Void>> resetStaticSiteApiKeyWithResponseAsync(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resetPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resetPropertiesEnvelope is required and cannot be null."));
        }
        resetPropertiesEnvelope.validate();
        return FluxUtil.withContext(context -> this.service.resetStaticSiteApiKey(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), resetPropertiesEnvelope, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> resetStaticSiteApiKeyWithResponseAsync(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resetPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resetPropertiesEnvelope is required and cannot be null."));
        }
        resetPropertiesEnvelope.validate();
        context = this.client.mergeContext(context);
        return this.service.resetStaticSiteApiKey(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), resetPropertiesEnvelope, context);
    }

    @Override
    public Mono<Void> resetStaticSiteApiKeyAsync(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        return this.resetStaticSiteApiKeyWithResponseAsync(resourceGroupName, name, resetPropertiesEnvelope).flatMap(res -> Mono.empty());
    }

    @Override
    public void resetStaticSiteApiKey(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        this.resetStaticSiteApiKeyAsync(resourceGroupName, name, resetPropertiesEnvelope).block();
    }

    @Override
    public Response<Void> resetStaticSiteApiKeyWithResponse(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope, Context context) {
        return (Response)this.resetStaticSiteApiKeyWithResponseAsync(resourceGroupName, name, resetPropertiesEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> getStaticSitesByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getStaticSitesByResourceGroupNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> getStaticSitesByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getStaticSitesByResourceGroupNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteUsersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteUsersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getStaticSiteBuildsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getStaticSiteBuildsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteBuildFunctionsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteBuildFunctionsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteCustomDomainsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteCustomDomainsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listStaticSiteFunctionsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteFunctionsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    private static interface StaticSitesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/staticSites")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteArmResourceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteArmResourceInner>> createOrUpdateStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSiteArmResourceInner var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deleteStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteArmResourceInner>> updateStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSitePatchResource var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/listUsers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserCollection>> listStaticSiteUsers(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="authprovider") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deleteStaticSiteUser(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="authprovider") String var4, @PathParam(value="userid") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUser(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="authprovider") String var4, @PathParam(value="userid") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") StaticSiteUserArmResourceInner var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteBuildCollection>> getStaticSiteBuilds(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="prId") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deleteStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="prId") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/config/functionappsettings")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="prId") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") StringDictionaryInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/functions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteBuildFunctions(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="prId") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/listFunctionAppSettings")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="prId") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/functionappsettings")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StringDictionaryInner var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/createUserInvitation")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLink(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSiteUserInvitationRequestResource var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCustomDomainOverviewCollection>> listStaticSiteCustomDomains(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> createOrUpdateStaticSiteCustomDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="domainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deleteStaticSiteCustomDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="domainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}/validate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> validateCustomDomainCanBeAddedToStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="domainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/detach")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> detachStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/functions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteFunctions(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listFunctionAppSettings")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listSecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteSecrets(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/resetapikey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> resetStaticSiteApiKey(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSiteResetPropertiesArmResource var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> getStaticSitesByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserCollection>> listStaticSiteUsersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteBuildCollection>> getStaticSiteBuildsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteBuildFunctionsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCustomDomainOverviewCollection>> listStaticSiteCustomDomainsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteFunctionsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

