/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.CapabilityInner;
import com.azure.resourcemanager.appservice.models.SkuCapacity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class GlobalCsmSkuDescription {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(GlobalCsmSkuDescription.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="tier")
    private String tier;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="family")
    private String family;
    @JsonProperty(value="capacity")
    private SkuCapacity capacity;
    @JsonProperty(value="locations")
    private List<String> locations;
    @JsonProperty(value="capabilities")
    private List<CapabilityInner> capabilities;

    public String name() {
        return this.name;
    }

    public GlobalCsmSkuDescription withName(String name) {
        this.name = name;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public GlobalCsmSkuDescription withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public String size() {
        return this.size;
    }

    public GlobalCsmSkuDescription withSize(String size) {
        this.size = size;
        return this;
    }

    public String family() {
        return this.family;
    }

    public GlobalCsmSkuDescription withFamily(String family) {
        this.family = family;
        return this;
    }

    public SkuCapacity capacity() {
        return this.capacity;
    }

    public GlobalCsmSkuDescription withCapacity(SkuCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public GlobalCsmSkuDescription withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<CapabilityInner> capabilities() {
        return this.capabilities;
    }

    public GlobalCsmSkuDescription withCapabilities(List<CapabilityInner> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public void validate() {
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }
}

