/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinitionInner;
import com.azure.resourcemanager.appservice.models.DiagnosticMetricSet;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ResponseMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AnalysisDataInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AnalysisDataInner.class);
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="detectorDefinition")
    private DetectorDefinitionInner detectorDefinition;
    @JsonProperty(value="metrics")
    private List<DiagnosticMetricSet> metrics;
    @JsonProperty(value="data")
    private List<List<NameValuePair>> data;
    @JsonProperty(value="detectorMetaData")
    private ResponseMetadata detectorMetadata;

    public String source() {
        return this.source;
    }

    public AnalysisDataInner withSource(String source) {
        this.source = source;
        return this;
    }

    public DetectorDefinitionInner detectorDefinition() {
        return this.detectorDefinition;
    }

    public AnalysisDataInner withDetectorDefinition(DetectorDefinitionInner detectorDefinition) {
        this.detectorDefinition = detectorDefinition;
        return this;
    }

    public List<DiagnosticMetricSet> metrics() {
        return this.metrics;
    }

    public AnalysisDataInner withMetrics(List<DiagnosticMetricSet> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<List<NameValuePair>> data() {
        return this.data;
    }

    public AnalysisDataInner withData(List<List<NameValuePair>> data) {
        this.data = data;
        return this;
    }

    public ResponseMetadata detectorMetadata() {
        return this.detectorMetadata;
    }

    public AnalysisDataInner withDetectorMetadata(ResponseMetadata detectorMetadata) {
        this.detectorMetadata = detectorMetadata;
        return this;
    }

    public void validate() {
        if (this.detectorDefinition() != null) {
            this.detectorDefinition().validate();
        }
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
        if (this.data() != null) {
            this.data().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.detectorMetadata() != null) {
            this.detectorMetadata().validate();
        }
    }
}

